/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import dev.sigstore.tuf.model.Signature;
import dev.sigstore.tuf.model.TargetMeta;
import dev.sigstore.tuf.model.Targets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Targets", generator="Immutables")
@Immutable
public final class ImmutableTargets
implements Targets {
    private final ImmutableList<Signature> signatures;
    private final JsonElement rawSignedMeta;
    private final transient TargetMeta signedMeta;
    private volatile transient long lazyInitBitmap;
    private static final long CANONICAL_SIGNED_BYTES_LAZY_INIT_BIT = 1L;
    private transient byte[] canonicalSignedBytes;

    private ImmutableTargets(ImmutableList<Signature> signatures, JsonElement rawSignedMeta) {
        this.signatures = signatures;
        this.rawSignedMeta = rawSignedMeta;
        this.signedMeta = Objects.requireNonNull(Targets.super.getSignedMeta(), "signedMeta");
    }

    public ImmutableList<Signature> getSignatures() {
        return this.signatures;
    }

    @Override
    public JsonElement getRawSignedMeta() {
        return this.rawSignedMeta;
    }

    @Override
    public TargetMeta getSignedMeta() {
        return this.signedMeta;
    }

    public final ImmutableTargets withSignatures(Signature ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableTargets.validate(new ImmutableTargets((ImmutableList<Signature>)newValue, this.rawSignedMeta));
    }

    public final ImmutableTargets withSignatures(Iterable<? extends Signature> elements) {
        if (this.signatures == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableTargets.validate(new ImmutableTargets((ImmutableList<Signature>)newValue, this.rawSignedMeta));
    }

    public final ImmutableTargets withRawSignedMeta(JsonElement value) {
        if (this.rawSignedMeta == value) {
            return this;
        }
        JsonElement newValue = Objects.requireNonNull(value, "rawSignedMeta");
        return ImmutableTargets.validate(new ImmutableTargets(this.signatures, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTargets && this.equalTo(0, (ImmutableTargets)another);
    }

    private boolean equalTo(int synthetic, ImmutableTargets another) {
        return this.signatures.equals(another.signatures) && this.rawSignedMeta.equals(another.rawSignedMeta) && this.signedMeta.equals(another.signedMeta);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.signatures.hashCode();
        h += (h << 5) + this.rawSignedMeta.hashCode();
        h += (h << 5) + this.signedMeta.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Targets").omitNullValues().add("signatures", this.signatures).add("rawSignedMeta", (Object)this.rawSignedMeta).add("signedMeta", (Object)this.signedMeta).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getCanonicalSignedBytes() throws IOException {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableTargets immutableTargets = this;
            synchronized (immutableTargets) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.canonicalSignedBytes = Objects.requireNonNull(Targets.super.getCanonicalSignedBytes(), "canonicalSignedBytes");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.canonicalSignedBytes;
    }

    private static ImmutableTargets validate(ImmutableTargets instance) {
        instance.checkType();
        return instance;
    }

    public static ImmutableTargets copyOf(Targets instance) {
        if (instance instanceof ImmutableTargets) {
            return (ImmutableTargets)instance;
        }
        return ImmutableTargets.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Targets", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RAW_SIGNED_META = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Signature> signatures = ImmutableList.builder();
        @Nullable
        private JsonElement rawSignedMeta;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Targets instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllSignatures(instance.getSignatures());
            this.rawSignedMeta(instance.getRawSignedMeta());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignatures(Signature element) {
            this.signatures.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignatures(Signature ... elements) {
            this.signatures.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signatures(Iterable<? extends Signature> elements) {
            this.signatures = ImmutableList.builder();
            return this.addAllSignatures(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSignatures(Iterable<? extends Signature> elements) {
            this.signatures.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rawSignedMeta(JsonElement rawSignedMeta) {
            this.rawSignedMeta = Objects.requireNonNull(rawSignedMeta, "rawSignedMeta");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTargets build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableTargets.validate(new ImmutableTargets((ImmutableList<Signature>)this.signatures.build(), this.rawSignedMeta));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("rawSignedMeta");
            }
            return "Cannot build Targets, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

