/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.maven.war;

import java.io.File;
import java.util.Collections;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.War;

public class WarArchiveClassesPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getTasks().withType(War.class, war -> {
            Property archiveClasses = project.getObjects().property(Boolean.class).convention((Object)false);
            war.getExtensions().add("archiveClasses", (Object)archiveClasses);
            TaskProvider warClassesJar = project.getTasks().register(war.getName() + "ClassesJar", Jar.class, jar -> {
                jar.getArchiveBaseName().convention((Provider)war.getArchiveBaseName());
                jar.getArchiveAppendix().convention((Provider)war.getArchiveAppendix());
                jar.getArchiveVersion().convention((Provider)war.getArchiveVersion());
                jar.getArchiveClassifier().convention((Provider)war.getArchiveClassifier());
                jar.getDestinationDirectory().set(war.getTemporaryDir());
            });
            project.afterEvaluate(p -> {
                warClassesJar.configure(jar -> jar.setEnabled(((Boolean)archiveClasses.get()).booleanValue()));
                if (((Boolean)archiveClasses.get()).booleanValue()) {
                    FileCollection warClasspath = war.getClasspath();
                    warClassesJar.configure(jar -> jar.from(new Object[]{warClasspath != null ? warClasspath.filter(File::isDirectory) : Collections.emptyList()}));
                    war.setClasspath(warClasspath == null ? null : warClasspath.filter(File::isFile).plus((FileCollection)project.files(new Object[]{warClassesJar})));
                }
            });
        });
    }
}

