/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.okhttp.internal;

import io.freefair.gradle.plugins.okhttp.internal.ProgressListener;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

class ProgressRequestBody
extends RequestBody {
    private final RequestBody requestBody;
    private final ProgressListener progressListener;

    ProgressRequestBody(RequestBody requestBody, ProgressListener progressListener) {
        this.requestBody = requestBody;
        this.progressListener = progressListener;
    }

    @Nullable
    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.requestBody.contentLength();
    }

    public void writeTo(@Nonnull BufferedSink bufferedSink) throws IOException {
        BufferedSink buffer = Okio.buffer((Sink)this.sink((Sink)bufferedSink));
        this.requestBody.writeTo(buffer);
        buffer.close();
    }

    public boolean isDuplex() {
        return this.requestBody.isDuplex();
    }

    public boolean isOneShot() {
        return this.requestBody.isOneShot();
    }

    private Sink sink(Sink sink) {
        return new ForwardingSink(sink){
            long totalBytesWritten;
            {
                this.totalBytesWritten = 0L;
            }

            public void write(@Nonnull Buffer source, long byteCount) throws IOException {
                super.write(source, byteCount);
                this.totalBytesWritten += byteCount;
                ProgressRequestBody.this.progressListener.writeUpdate(this.totalBytesWritten, ProgressRequestBody.this.requestBody.contentLength());
            }
        };
    }
}

