/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin;

import io.github.gradlenexus.publishplugin.AbstractNexusStagingRepositoryTask;
import io.github.gradlenexus.publishplugin.NexusPublishExtension;
import io.github.gradlenexus.publishplugin.NexusRepository;
import io.github.gradlenexus.publishplugin.internal.NexusClient;
import io.github.gradlenexus.publishplugin.internal.StagingRepositoryDescriptor;
import io.github.gradlenexus.publishplugin.internal.StagingRepositoryDescriptorRegistry;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.HttpUrl;
import java.net.URI;
import java.time.Duration;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.GradleException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/gradlenexus/publishplugin/InitializeNexusStagingRepository;", "Lio/github/gradlenexus/publishplugin/AbstractNexusStagingRepositoryTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "extension", "Lio/github/gradlenexus/publishplugin/NexusPublishExtension;", "repository", "Lio/github/gradlenexus/publishplugin/NexusRepository;", "registry", "Lorg/gradle/api/provider/Provider;", "Lio/github/gradlenexus/publishplugin/internal/StagingRepositoryDescriptorRegistry;", "(Lorg/gradle/api/model/ObjectFactory;Lio/github/gradlenexus/publishplugin/NexusPublishExtension;Lio/github/gradlenexus/publishplugin/NexusRepository;Lorg/gradle/api/provider/Provider;)V", "packageGroup", "Lorg/gradle/api/provider/Property;", "", "getPackageGroup", "()Lorg/gradle/api/provider/Property;", "createStagingRepo", "", "determineStagingProfileId", "client", "Lio/github/gradlenexus/publishplugin/internal/NexusClient;", "publish-plugin"})
@SourceDebugExtension(value={"SMAP\nInitializeNexusStagingRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InitializeNexusStagingRepository.kt\nio/github/gradlenexus/publishplugin/InitializeNexusStagingRepository\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n*L\n1#1,69:1\n59#2:70\n*E\n*S KotlinDebug\n*F\n+ 1 InitializeNexusStagingRepository.kt\nio/github/gradlenexus/publishplugin/InitializeNexusStagingRepository\n*L\n41#1:70\n*E\n"})
public class InitializeNexusStagingRepository
extends AbstractNexusStagingRepositoryTask {
    @Optional
    @Input
    @NotNull
    private final Property<String> packageGroup;
    private final Provider<StagingRepositoryDescriptorRegistry> registry;

    @NotNull
    public final Property<String> getPackageGroup() {
        return this.packageGroup;
    }

    @TaskAction
    public final void createStagingRepo() {
        Object object = this.getRepository().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"repository.get()");
        NexusRepository repository = (NexusRepository)object;
        Object object2 = repository.getNexusUrl().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"repository.nexusUrl.get()");
        URI serverUrl = (URI)object2;
        NexusClient client = new NexusClient(serverUrl, (String)repository.getUsername().getOrNull(), (String)repository.getPassword().getOrNull(), (Duration)this.getClientTimeout().getOrNull(), (Duration)this.getConnectTimeout().getOrNull());
        String stagingProfileId = this.determineStagingProfileId(repository, client);
        this.getLogger().info("Creating staging repository for {} at {}, stagingProfileId '{}'", new Object[]{repository.getName(), serverUrl, stagingProfileId});
        Object object3 = this.getRepositoryDescription().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"repositoryDescription.get()");
        StagingRepositoryDescriptor descriptor = client.createStagingRepository(stagingProfileId, (String)object3);
        HttpUrl httpUrl = HttpUrl.get(serverUrl);
        if (httpUrl == null) {
            Intrinsics.throwNpe();
        }
        HttpUrl httpUrl2 = httpUrl.newBuilder().addEncodedPathSegments("repositories/" + descriptor.getStagingRepositoryId() + "/content/").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl2, (String)"HttpUrl.get(serverUrl)!!\u2026oryId}/content/\").build()");
        HttpUrl consumerUrl = httpUrl2;
        this.getLogger().lifecycle("Created staging repository '{}' at {}", new Object[]{descriptor.getStagingRepositoryId(), consumerUrl});
        ((StagingRepositoryDescriptorRegistry)this.registry.get()).set(repository.getName(), descriptor);
    }

    private final String determineStagingProfileId(NexusRepository repository, NexusClient client) {
        String stagingProfileId = (String)repository.getStagingProfileId().getOrNull();
        if (stagingProfileId == null) {
            Object object = this.packageGroup.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"packageGroup.get()");
            String packageGroup = (String)object;
            this.getLogger().info("No stagingProfileId set, querying for packageGroup '{}'", (Object)packageGroup);
            String string = client.findStagingProfileId(packageGroup);
            if (string == null) {
                throw (Throwable)new GradleException("Failed to find staging profile for package group: " + packageGroup);
            }
            stagingProfileId = string;
        }
        return stagingProfileId;
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public InitializeNexusStagingRepository(@NotNull ObjectFactory objects, @NotNull NexusPublishExtension extension, @NotNull NexusRepository repository, @NotNull Provider<StagingRepositoryDescriptorRegistry> registry) {
        void $this$apply;
        Property property;
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull(registry, (String)"registry");
        super(objects, extension, repository);
        this.registry = registry;
        ObjectFactory $this$property$iv = objects;
        boolean $i$f$property22 = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        Property $i$f$property22 = property = property2;
        InitializeNexusStagingRepository initializeNexusStagingRepository = this;
        boolean bl = false;
        $this$apply.set((Provider)extension.getPackageGroup());
        Unit unit = Unit.INSTANCE;
        initializeNexusStagingRepository.packageGroup = property;
    }
}

