/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin.internal;

import io.github.gradlenexus.publishplugin.internal.StagingRepository;
import io.github.gradlenexus.publishplugin.internal.StagingRepositoryDescriptor;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.Credentials;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.Interceptor;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.OkHttpClient;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.Response;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.ResponseBody;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.Call;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.Retrofit;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.converter.gson.GsonConverterFactory;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.http.Body;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.http.GET;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.http.Headers;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.http.POST;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.http.Path;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001:\u0007\u001f !\"#$%B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J \u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u00052\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006&"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient;", "", "baseUrl", "Ljava/net/URI;", "username", "", "password", "timeout", "Ljava/time/Duration;", "connectTimeout", "(Ljava/net/URI;Ljava/lang/String;Ljava/lang/String;Ljava/time/Duration;Ljava/time/Duration;)V", "api", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$NexusApi;", "closeStagingRepository", "", "stagingRepositoryId", "description", "createStagingRepository", "Lio/github/gradlenexus/publishplugin/internal/StagingRepositoryDescriptor;", "stagingProfileId", "failure", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "action", "response", "Lio/github/gradlenexus/publishplugin/shadow/retrofit2/Response;", "findStagingProfileId", "packageGroup", "getStagingRepositoryStateById", "Lio/github/gradlenexus/publishplugin/internal/StagingRepository;", "releaseStagingRepository", "CreatedStagingRepository", "Description", "Dto", "NexusApi", "ReadStagingRepository", "StagingProfile", "StagingRepositoryToTransit", "publish-plugin"})
@SourceDebugExtension(value={"SMAP\nNexusClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NexusClient.kt\nio/github/gradlenexus/publishplugin/internal/NexusClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _CollectionsJvm.kt\nkotlin/collections/CollectionsKt___CollectionsJvmKt\n*L\n1#1,194:1\n766#2:195\n857#2,2:196\n1963#2,14:199\n89#3:198\n*E\n*S KotlinDebug\n*F\n+ 1 NexusClient.kt\nio/github/gradlenexus/publishplugin/internal/NexusClient\n*L\n81#1:195\n81#1,2:196\n90#1,14:199\n90#1:198\n*E\n"})
public class NexusClient {
    private final NexusApi api;
    private final URI baseUrl;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String findStagingProfileId(@NotNull String packageGroup) {
        Object v4;
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)packageGroup, (String)"packageGroup");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Dto<List<StagingProfile>>> response = this.api.getStagingProfiles().execute();
        Intrinsics.checkExpressionValueIsNotNull(response, (String)"api.stagingProfiles.execute()");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Dto<List<StagingProfile>>> response2 = response;
        if (!response2.isSuccessful()) {
            throw (Throwable)this.failure("load staging profiles", response2);
        }
        Dto<List<StagingProfile>> dto = response2.body();
        Object object = dto;
        if (dto == null) return null;
        List<StagingProfile> list = ((Dto)object).getData();
        object = list;
        if (list == null) return null;
        Iterable $this$filter$iv = (Iterable)object;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StagingProfile profile = (StagingProfile)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default((String)packageGroup, (String)profile.getName(), (boolean)false, (int)2, null) && (packageGroup.length() == profile.getName().length() || packageGroup.charAt(profile.getName().length()) == '.'))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxBy$iv = (List)destination$iv$iv;
        boolean $i$f$maxBy = false;
        Iterable $this$maxByOrNull$iv$iv = $this$maxBy$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv$iv = $this$maxByOrNull$iv$iv.iterator();
        if (!iterator$iv$iv.hasNext()) {
            v4 = null;
        } else {
            Object maxElem$iv$iv = iterator$iv$iv.next();
            if (!iterator$iv$iv.hasNext()) {
                v4 = maxElem$iv$iv;
            } else {
                StagingProfile it = (StagingProfile)maxElem$iv$iv;
                boolean bl = false;
                int maxValue$iv$iv = it.getName().length();
                do {
                    Object e$iv$iv = iterator$iv$iv.next();
                    StagingProfile it2 = (StagingProfile)e$iv$iv;
                    $i$a$-maxBy-NexusClient$findStagingProfileId$2 = false;
                    int v$iv$iv = it2.getName().length();
                    if (maxValue$iv$iv >= v$iv$iv) continue;
                    maxElem$iv$iv = e$iv$iv;
                    maxValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv.hasNext());
                v4 = maxElem$iv$iv;
            }
        }
        StagingProfile stagingProfile = v4;
        object = stagingProfile;
        if (stagingProfile == null) return null;
        String string = ((StagingProfile)object).getId();
        return string;
    }

    @NotNull
    public final StagingRepositoryDescriptor createStagingRepository(@NotNull String stagingProfileId, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)stagingProfileId, (String)"stagingProfileId");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Dto<CreatedStagingRepository>> response = this.api.startStagingRepo(stagingProfileId, new Dto<Description>(new Description(description))).execute();
        Intrinsics.checkExpressionValueIsNotNull(response, (String)"api.startStagingRepo(sta\u2026(description))).execute()");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Dto<CreatedStagingRepository>> response2 = response;
        if (!response2.isSuccessful()) {
            throw (Throwable)this.failure("create staging repository", response2);
        }
        Dto<CreatedStagingRepository> dto = response2.body();
        if (dto == null || (dto = dto.getData()) == null || (dto = ((CreatedStagingRepository)((Object)dto)).getStagedRepositoryId()) == null) {
            throw (Throwable)new RuntimeException("No response body");
        }
        Dto<CreatedStagingRepository> stagingRepositoryId = dto;
        return new StagingRepositoryDescriptor(this.baseUrl, (String)((Object)stagingRepositoryId));
    }

    public void closeStagingRepository(@NotNull String stagingRepositoryId, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)stagingRepositoryId, (String)"stagingRepositoryId");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Unit> response = this.api.closeStagingRepo(new Dto<StagingRepositoryToTransit>(new StagingRepositoryToTransit(CollectionsKt.listOf((Object)stagingRepositoryId), description, false, 4, null))).execute();
        Intrinsics.checkExpressionValueIsNotNull(response, (String)"api.closeStagingRepo(Dto\u2026 description))).execute()");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Unit> response2 = response;
        if (!response2.isSuccessful()) {
            throw (Throwable)this.failure("close staging repository", response2);
        }
    }

    public void releaseStagingRepository(@NotNull String stagingRepositoryId, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)stagingRepositoryId, (String)"stagingRepositoryId");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Unit> response = this.api.releaseStagingRepo(new Dto<StagingRepositoryToTransit>(new StagingRepositoryToTransit(CollectionsKt.listOf((Object)stagingRepositoryId), description, false, 4, null))).execute();
        Intrinsics.checkExpressionValueIsNotNull(response, (String)"api.releaseStagingRepo(D\u2026 description))).execute()");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<Unit> response2 = response;
        if (!response2.isSuccessful()) {
            throw (Throwable)this.failure("release staging repository", response2);
        }
    }

    @NotNull
    public StagingRepository getStagingRepositoryStateById(@NotNull String stagingRepositoryId) {
        Intrinsics.checkParameterIsNotNull((Object)stagingRepositoryId, (String)"stagingRepositoryId");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<ReadStagingRepository> response = this.api.getStagingRepoById(stagingRepositoryId).execute();
        Intrinsics.checkExpressionValueIsNotNull(response, (String)"api.getStagingRepoById(s\u2026ngRepositoryId).execute()");
        io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<ReadStagingRepository> response2 = response;
        if (response2.code() == 404) {
            Object object = response2.errorBody();
            if (object != null && (object = ((ResponseBody)object).string()) != null) {
                if (StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)stagingRepositoryId, (boolean)false, (int)2, null)) {
                    return StagingRepository.Companion.notFound(stagingRepositoryId);
                }
            }
        }
        if (!response2.isSuccessful()) {
            throw (Throwable)this.failure("get staging repository by id", response2);
        }
        ReadStagingRepository readStagingRepo = response2.body();
        if (readStagingRepo != null) {
            boolean bl = Intrinsics.areEqual((Object)stagingRepositoryId, (Object)readStagingRepo.getRepositoryId());
            if (!bl) {
                boolean bl2 = false;
                String string = "Unexpected read repository id (" + stagingRepositoryId + " != " + readStagingRepo.getRepositoryId() + ')';
                throw new IllegalArgumentException(string.toString());
            }
            return new StagingRepository(readStagingRepo.getRepositoryId(), StagingRepository.State.Companion.parseString(readStagingRepo.getType()), readStagingRepo.getTransitioning());
        }
        return StagingRepository.Companion.notFound(stagingRepositoryId);
    }

    /*
     * WARNING - void declaration
     */
    private final RuntimeException failure(String action, io.github.gradlenexus.publishplugin.shadow.retrofit2.Response<?> response) {
        String message = "Failed to " + action + ", server at " + this.baseUrl + " responded with status code " + response.code();
        ResponseBody errorBody = response.errorBody();
        if (errorBody != null) {
            String string;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = new StringBuilder().append(message);
            try {
                stringBuilder = stringBuilder2;
                string = ", body: " + errorBody.string();
            }
            catch (IOException iOException) {
                void exception;
                stringBuilder = stringBuilder2;
                string = ", body: <error while reading body of error response, message: " + exception.getMessage() + '>';
            }
            message = stringBuilder.append(string).toString();
        }
        return new RuntimeException(message);
    }

    public NexusClient(@NotNull URI baseUrl, @Nullable String username, @Nullable String password, @Nullable Duration timeout, @Nullable Duration connectTimeout) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        this.baseUrl = baseUrl;
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        if (timeout != null) {
            httpClientBuilder.readTimeout(timeout).writeTimeout(timeout);
        }
        if (connectTimeout != null) {
            httpClientBuilder.connectTimeout(connectTimeout);
        }
        if (username != null || password != null) {
            String string;
            String string2 = username;
            if (string2 == null) {
                string2 = "";
            }
            if ((string = password) == null) {
                string = "";
            }
            String string3 = Credentials.basic(string2, string);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Credentials.basic(username ?: \"\", password ?: \"\")");
            final String credentials = string3;
            httpClientBuilder.addInterceptor(new Interceptor(){

                @Override
                @NotNull
                public final Response intercept(@NotNull Interceptor.Chain chain) {
                    Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                    return chain.proceed(chain.request().newBuilder().header("Authorization", credentials).build());
                }
            });
        }
        httpClientBuilder.addInterceptor(new Interceptor(){

            @Override
            @NotNull
            public final Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Package package_ = this.getClass().getPackage();
                Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"javaClass.`package`");
                String string = package_.getImplementationVersion();
                if (string == null) {
                    string = "dev";
                }
                String version = string;
                return chain.proceed(chain.request().newBuilder().header("User-Agent", "gradle-nexus-publish-plugin/" + version).build());
            }
        });
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.baseUrl.toString()).client(httpClientBuilder.build()).addConverterFactory(GsonConverterFactory.create()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"Retrofit.Builder()\n     \u2026e())\n            .build()");
        Retrofit retrofit2 = retrofit;
        NexusApi nexusApi = retrofit2.create(NexusApi.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)nexusApi, (String)"retrofit.create(NexusApi::class.java)");
        this.api = nexusApi;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bb\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H'J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\b\b\u0001\u0010\u000f\u001a\u00020\u0010H'J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H'J.\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00040\u00032\b\b\u0001\u0010\u0014\u001a\u00020\u00102\u000e\b\u0001\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004H'R&\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$NexusApi;", "", "stagingProfiles", "Lio/github/gradlenexus/publishplugin/shadow/retrofit2/Call;", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$Dto;", "", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$StagingProfile;", "getStagingProfiles", "()Lretrofit2/Call;", "closeStagingRepo", "", "stagingRepoToClose", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$StagingRepositoryToTransit;", "getStagingRepoById", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$ReadStagingRepository;", "stagingRepoId", "", "releaseStagingRepo", "startStagingRepo", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$CreatedStagingRepository;", "stagingProfileId", "description", "Lio/github/gradlenexus/publishplugin/internal/NexusClient$Description;", "Companion", "publish-plugin"})
    private static interface NexusApi {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Headers(value={"Accept: application/json"})
        @GET(value="staging/profiles")
        @NotNull
        public Call<Dto<List<StagingProfile>>> getStagingProfiles();

        @Headers(value={"Content-Type: application/json"})
        @POST(value="staging/profiles/{stagingProfileId}/start")
        @NotNull
        public Call<Dto<CreatedStagingRepository>> startStagingRepo(@Path(value="stagingProfileId") @NotNull String var1, @Body @NotNull Dto<Description> var2);

        @Headers(value={"Content-Type: application/json"})
        @POST(value="staging/bulk/close")
        @NotNull
        public Call<Unit> closeStagingRepo(@Body @NotNull Dto<StagingRepositoryToTransit> var1);

        @Headers(value={"Content-Type: application/json"})
        @POST(value="staging/bulk/promote")
        @NotNull
        public Call<Unit> releaseStagingRepo(@Body @NotNull Dto<StagingRepositoryToTransit> var1);

        @Headers(value={"Accept: application/json"})
        @GET(value="staging/repository/{stagingRepoId}")
        @NotNull
        public Call<ReadStagingRepository> getStagingRepoById(@Path(value="stagingRepoId") @NotNull String var1);

        @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$NexusApi$Companion;", "", "()V", "RELEASE_OPERATION_NAME_IN_NEXUS", "", "publish-plugin"})
        public static final class Companion {
            private static final String RELEASE_OPERATION_NAME_IN_NEXUS = "promote";
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u001c\u0010\u0003\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\b\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$Dto;", "T", "", "data", "(Ljava/lang/Object;)V", "getData", "()Ljava/lang/Object;", "setData", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lio/github/gradlenexus/publishplugin/internal/NexusClient$Dto;", "equals", "", "other", "hashCode", "", "toString", "", "publish-plugin"})
    public static final class Dto<T> {
        private T data;

        public final T getData() {
            return this.data;
        }

        public final void setData(T t) {
            this.data = t;
        }

        public Dto(T data) {
            this.data = data;
        }

        public final T component1() {
            return this.data;
        }

        @NotNull
        public final Dto<T> copy(T data) {
            return new Dto<T>(data);
        }

        public static /* synthetic */ Dto copy$default(Dto dto, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = dto.data;
            }
            return dto.copy(object);
        }

        @NotNull
        public String toString() {
            return "Dto(data=" + this.data + ")";
        }

        public int hashCode() {
            T t = this.data;
            return t != null ? t.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Dto)) break block3;
                    Dto dto = (Dto)object;
                    if (!Intrinsics.areEqual(this.data, dto.data)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$StagingProfile;", "", "id", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "getName", "setName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "publish-plugin"})
    public static final class StagingProfile {
        @NotNull
        private String id;
        @NotNull
        private String name;

        @NotNull
        public final String getId() {
            return this.id;
        }

        public final void setId(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.id = string;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.name = string;
        }

        public StagingProfile(@NotNull String id, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.id = id;
            this.name = name;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final StagingProfile copy(@NotNull String id, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new StagingProfile(id, name);
        }

        public static /* synthetic */ StagingProfile copy$default(StagingProfile stagingProfile, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = stagingProfile.id;
            }
            if ((n & 2) != 0) {
                string2 = stagingProfile.name;
            }
            return stagingProfile.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "StagingProfile(id=" + this.id + ", name=" + this.name + ")";
        }

        public int hashCode() {
            String string = this.id;
            String string2 = this.name;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StagingProfile)) break block3;
                    StagingProfile stagingProfile = (StagingProfile)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)stagingProfile.id) || !Intrinsics.areEqual((Object)this.name, (Object)stagingProfile.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$Description;", "", "description", "", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "publish-plugin"})
    public static final class Description {
        @NotNull
        private final String description;

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public Description(@NotNull String description) {
            Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
            this.description = description;
        }

        @NotNull
        public final String component1() {
            return this.description;
        }

        @NotNull
        public final Description copy(@NotNull String description) {
            Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
            return new Description(description);
        }

        public static /* synthetic */ Description copy$default(Description description, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = description.description;
            }
            return description.copy(string);
        }

        @NotNull
        public String toString() {
            return "Description(description=" + this.description + ")";
        }

        public int hashCode() {
            String string = this.description;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Description)) break block3;
                    Description description = (Description)object;
                    if (!Intrinsics.areEqual((Object)this.description, (Object)description.description)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$CreatedStagingRepository;", "", "stagedRepositoryId", "", "(Ljava/lang/String;)V", "getStagedRepositoryId", "()Ljava/lang/String;", "setStagedRepositoryId", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "publish-plugin"})
    public static final class CreatedStagingRepository {
        @NotNull
        private String stagedRepositoryId;

        @NotNull
        public final String getStagedRepositoryId() {
            return this.stagedRepositoryId;
        }

        public final void setStagedRepositoryId(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.stagedRepositoryId = string;
        }

        public CreatedStagingRepository(@NotNull String stagedRepositoryId) {
            Intrinsics.checkParameterIsNotNull((Object)stagedRepositoryId, (String)"stagedRepositoryId");
            this.stagedRepositoryId = stagedRepositoryId;
        }

        @NotNull
        public final String component1() {
            return this.stagedRepositoryId;
        }

        @NotNull
        public final CreatedStagingRepository copy(@NotNull String stagedRepositoryId) {
            Intrinsics.checkParameterIsNotNull((Object)stagedRepositoryId, (String)"stagedRepositoryId");
            return new CreatedStagingRepository(stagedRepositoryId);
        }

        public static /* synthetic */ CreatedStagingRepository copy$default(CreatedStagingRepository createdStagingRepository, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = createdStagingRepository.stagedRepositoryId;
            }
            return createdStagingRepository.copy(string);
        }

        @NotNull
        public String toString() {
            return "CreatedStagingRepository(stagedRepositoryId=" + this.stagedRepositoryId + ")";
        }

        public int hashCode() {
            String string = this.stagedRepositoryId;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CreatedStagingRepository)) break block3;
                    CreatedStagingRepository createdStagingRepository = (CreatedStagingRepository)object;
                    if (!Intrinsics.areEqual((Object)this.stagedRepositoryId, (Object)createdStagingRepository.stagedRepositoryId)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$ReadStagingRepository;", "", "repositoryId", "", "type", "transitioning", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getRepositoryId", "()Ljava/lang/String;", "setRepositoryId", "(Ljava/lang/String;)V", "getTransitioning", "()Z", "setTransitioning", "(Z)V", "getType", "setType", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "publish-plugin"})
    public static final class ReadStagingRepository {
        @NotNull
        private String repositoryId;
        @NotNull
        private String type;
        private boolean transitioning;

        @NotNull
        public final String getRepositoryId() {
            return this.repositoryId;
        }

        public final void setRepositoryId(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.repositoryId = string;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final void setType(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.type = string;
        }

        public final boolean getTransitioning() {
            return this.transitioning;
        }

        public final void setTransitioning(boolean bl) {
            this.transitioning = bl;
        }

        public ReadStagingRepository(@NotNull String repositoryId, @NotNull String type, boolean transitioning) {
            Intrinsics.checkParameterIsNotNull((Object)repositoryId, (String)"repositoryId");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            this.repositoryId = repositoryId;
            this.type = type;
            this.transitioning = transitioning;
        }

        @NotNull
        public final String component1() {
            return this.repositoryId;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        public final boolean component3() {
            return this.transitioning;
        }

        @NotNull
        public final ReadStagingRepository copy(@NotNull String repositoryId, @NotNull String type, boolean transitioning) {
            Intrinsics.checkParameterIsNotNull((Object)repositoryId, (String)"repositoryId");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            return new ReadStagingRepository(repositoryId, type, transitioning);
        }

        public static /* synthetic */ ReadStagingRepository copy$default(ReadStagingRepository readStagingRepository, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = readStagingRepository.repositoryId;
            }
            if ((n & 2) != 0) {
                string2 = readStagingRepository.type;
            }
            if ((n & 4) != 0) {
                bl = readStagingRepository.transitioning;
            }
            return readStagingRepository.copy(string, string2, bl);
        }

        @NotNull
        public String toString() {
            return "ReadStagingRepository(repositoryId=" + this.repositoryId + ", type=" + this.type + ", transitioning=" + this.transitioning + ")";
        }

        public int hashCode() {
            String string = this.repositoryId;
            String string2 = this.type;
            int n = ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
            int n2 = this.transitioning ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ReadStagingRepository)) break block3;
                    ReadStagingRepository readStagingRepository = (ReadStagingRepository)object;
                    if (!Intrinsics.areEqual((Object)this.repositoryId, (Object)readStagingRepository.repositoryId) || !Intrinsics.areEqual((Object)this.type, (Object)readStagingRepository.type) || this.transitioning != readStagingRepository.transitioning) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018"}, d2={"Lio/github/gradlenexus/publishplugin/internal/NexusClient$StagingRepositoryToTransit;", "", "stagedRepositoryIds", "", "", "description", "autoDropAfterRelease", "", "(Ljava/util/List;Ljava/lang/String;Z)V", "getAutoDropAfterRelease", "()Z", "getDescription", "()Ljava/lang/String;", "getStagedRepositoryIds", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "publish-plugin"})
    public static final class StagingRepositoryToTransit {
        @NotNull
        private final List<String> stagedRepositoryIds;
        @NotNull
        private final String description;
        private final boolean autoDropAfterRelease;

        @NotNull
        public final List<String> getStagedRepositoryIds() {
            return this.stagedRepositoryIds;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public final boolean getAutoDropAfterRelease() {
            return this.autoDropAfterRelease;
        }

        public StagingRepositoryToTransit(@NotNull List<String> stagedRepositoryIds, @NotNull String description, boolean autoDropAfterRelease) {
            Intrinsics.checkParameterIsNotNull(stagedRepositoryIds, (String)"stagedRepositoryIds");
            Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
            this.stagedRepositoryIds = stagedRepositoryIds;
            this.description = description;
            this.autoDropAfterRelease = autoDropAfterRelease;
        }

        public /* synthetic */ StagingRepositoryToTransit(List list, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(list, string, bl);
        }

        @NotNull
        public final List<String> component1() {
            return this.stagedRepositoryIds;
        }

        @NotNull
        public final String component2() {
            return this.description;
        }

        public final boolean component3() {
            return this.autoDropAfterRelease;
        }

        @NotNull
        public final StagingRepositoryToTransit copy(@NotNull List<String> stagedRepositoryIds, @NotNull String description, boolean autoDropAfterRelease) {
            Intrinsics.checkParameterIsNotNull(stagedRepositoryIds, (String)"stagedRepositoryIds");
            Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
            return new StagingRepositoryToTransit(stagedRepositoryIds, description, autoDropAfterRelease);
        }

        public static /* synthetic */ StagingRepositoryToTransit copy$default(StagingRepositoryToTransit stagingRepositoryToTransit, List list, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                list = stagingRepositoryToTransit.stagedRepositoryIds;
            }
            if ((n & 2) != 0) {
                string = stagingRepositoryToTransit.description;
            }
            if ((n & 4) != 0) {
                bl = stagingRepositoryToTransit.autoDropAfterRelease;
            }
            return stagingRepositoryToTransit.copy(list, string, bl);
        }

        @NotNull
        public String toString() {
            return "StagingRepositoryToTransit(stagedRepositoryIds=" + this.stagedRepositoryIds + ", description=" + this.description + ", autoDropAfterRelease=" + this.autoDropAfterRelease + ")";
        }

        public int hashCode() {
            List<String> list = this.stagedRepositoryIds;
            String string = this.description;
            int n = ((list != null ? ((Object)list).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31;
            int n2 = this.autoDropAfterRelease ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StagingRepositoryToTransit)) break block3;
                    StagingRepositoryToTransit stagingRepositoryToTransit = (StagingRepositoryToTransit)object;
                    if (!Intrinsics.areEqual(this.stagedRepositoryIds, stagingRepositoryToTransit.stagedRepositoryIds) || !Intrinsics.areEqual((Object)this.description, (Object)stagingRepositoryToTransit.description) || this.autoDropAfterRelease != stagingRepositoryToTransit.autoDropAfterRelease) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

