/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.api;

import java.util.List;
import juuxel.loomquiltflower.api.QuiltflowerExtension;
import juuxel.loomquiltflower.impl.DeprecatedQuiltflowerExtension;
import juuxel.loomquiltflower.impl.PreferenceScanner;
import juuxel.loomquiltflower.impl.QuiltflowerExtensionImpl;
import juuxel.loomquiltflower.impl.QuiltflowerResolving;
import juuxel.loomquiltflower.impl.ReflectionUtil;
import juuxel.loomquiltflower.impl.module.LqfModule;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class LoomQuiltflowerPlugin
implements Plugin<Project> {
    private static final List<String> LOOMS = List.of(new String[]{"fabric-loom", "dev.architectury.loom", "org.quiltmc.loom", "gg.essential.loom", "babric-loom", "ornithe-loom"});
    private boolean applied = false;

    public void apply(Project target) {
        QuiltflowerExtension extension = (QuiltflowerExtension)target.getExtensions().create(QuiltflowerExtension.class, "quiltflower", QuiltflowerExtensionImpl.class, new Object[]{target});
        target.getExtensions().create(QuiltflowerExtension.class, "loomQuiltflower", DeprecatedQuiltflowerExtension.class, new Object[]{target, extension});
        PreferenceScanner.scan(target, extension);
        QuiltflowerResolving.setup(target, (QuiltflowerExtensionImpl)extension);
        for (String loomId : LOOMS) {
            target.getPluginManager().withPlugin(loomId, p -> {
                String moduleClass;
                if (this.applied) {
                    return;
                }
                if (LoomQuiltflowerPlugin.isNewLoom()) {
                    moduleClass = "juuxel.loomquiltflower.impl.module.Loom011Setup";
                } else if (LoomQuiltflowerPlugin.isNewArchLoom()) {
                    moduleClass = "juuxel.loomquiltflower.impl.module.ArchLoomSetup";
                } else if (LoomQuiltflowerPlugin.isOldLoom()) {
                    moduleClass = "juuxel.loomquiltflower.impl.module.OldLoomSetup";
                } else {
                    String message = "loom-quiltflower is not supported on this Loom version!\nReplace with loom-quiltflower-mini: https://github.com/Juuxel/loom-quiltflower-mini";
                    target.getLogger().error(message);
                    throw new UnsupportedOperationException(message);
                }
                try {
                    LqfModule module = LqfModule.get(moduleClass);
                    module.setup(target, extension);
                    ((QuiltflowerExtensionImpl)extension).setActiveModule(module);
                }
                catch (ReflectiveOperationException e) {
                    throw new GradleException("Could not find Quiltflower module " + moduleClass + ". Please report this!", (Throwable)e);
                }
                this.applied = true;
            });
        }
        target.afterEvaluate(p -> {
            if (!this.applied) {
                throw new GradleException("loom-quiltflower requires Loom! (One of " + LOOMS + ")");
            }
        });
    }

    private static boolean isOldLoom() {
        return ReflectionUtil.classExists("net.fabricmc.loom.decompilers.fernflower.AbstractForkedFFExecutor");
    }

    private static boolean isNewArchLoom() {
        return ReflectionUtil.classExists("net.fabricmc.loom.api.decompilers.architectury.ArchitecturyLoomDecompiler");
    }

    private static boolean isNewLoom() {
        return ReflectionUtil.classExists("net.fabricmc.loom.api.decompilers.DecompilerOptions");
    }
}

