/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.api;

import java.util.Map;
import juuxel.loomquiltflower.api.QuiltflowerPreferences;
import juuxel.loomquiltflower.api.QuiltflowerSource;
import juuxel.loomquiltflower.api.SourceFactory;
import kotlin.Pair;
import org.gradle.api.Action;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface QuiltflowerExtension {
    public static final String NAME = "quiltflower";

    public Property<String> getQuiltflowerVersion();

    public Property<QuiltflowerSource> getSource();

    public SourceFactory getSourceFactory();

    public QuiltflowerPreferences getPreferences();

    default public void preferences(Action<QuiltflowerPreferences> action) {
        action.execute((Object)this.getPreferences());
    }

    default public void preferences(Map<String, ?> preferences) {
        this.preferences((Action<QuiltflowerPreferences>)((Action)p -> p.put(preferences)));
    }

    default public void preferences(Pair<String, ?> ... preferences) {
        this.preferences((Action<QuiltflowerPreferences>)((Action)p -> p.put(preferences)));
    }

    default public void fromFile(Object path) {
        this.getSource().set((Object)this.getSourceFactory().fromFile(path));
    }

    default public void fromUrl(Object url) {
        this.getSource().set((Object)this.getSourceFactory().fromUrl(url));
    }

    default public void fromProjectRepositories() {
        this.getSource().set((Object)this.getSourceFactory().fromProjectRepositories((Provider<String>)this.getQuiltflowerVersion()));
    }

    default public void fromDependency(Object dependencyNotation) {
        this.getSource().set((Object)this.getSourceFactory().fromDependency(dependencyNotation));
    }

    default public void fromQuiltMaven() {
        this.getSource().set((Object)this.getSourceFactory().fromQuiltMaven((Provider<String>)this.getQuiltflowerVersion()));
    }

    default public void fromQuiltSnapshotMaven() {
        this.getSource().set((Object)this.getSourceFactory().fromQuiltSnapshotMaven((Provider<String>)this.getQuiltflowerVersion()));
    }

    public void fromLatestQuiltSnapshot();

    public Property<Boolean> getAddToRuntimeClasspath();
}

