/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.commons.Remapper;

public final class RelocationRemapper
extends Remapper {
    private final Map<String, String> patterns;
    private final Set<String> excludes;

    public RelocationRemapper(Map<String, String> patterns, Set<String> excludes) {
        this.patterns = patterns;
        this.excludes = excludes;
    }

    public static RelocationRemapper createQuiltflowerRelocator() {
        HashMap<String, String> patterns = new HashMap<String, String>();
        patterns.put("org/jetbrains/java/decompiler", "juuxel/loomquiltflower/impl/relocated/quiltflower");
        patterns.put("net/fabricmc/fernflower/api", "juuxel/loomquiltflower/impl/relocated/quiltflowerapi");
        Set<String> excludes = Collections.emptySet();
        return new RelocationRemapper(patterns, excludes);
    }

    public String map(String internalName) {
        if (!this.excludes.contains(internalName)) {
            for (Map.Entry<String, String> entry : this.patterns.entrySet()) {
                String from = entry.getKey();
                String to = entry.getValue();
                if (!internalName.startsWith(from + "/")) continue;
                return to + internalName.substring(from.length());
            }
        }
        return super.map(internalName);
    }
}

