/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.core;

import java.io.File;
import java.io.IOException;
import juuxel.loomquiltflower.core.RelocationRemapper;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.OutputConsumerPath;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.TinyRemapper;
import org.gradle.api.GradleException;

public final class Remapping {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remapQuiltflower(File input, File output, Iterable<File> inputDependencies) {
        try {
            TinyRemapper remapper = TinyRemapper.newRemapper().extraRemapper(RelocationRemapper.createQuiltflowerRelocator()).build();
            try (OutputConsumerPath consumer = new OutputConsumerPath.Builder(output.toPath()).build();){
                consumer.addNonClassFiles(input.toPath());
                remapper.readInputs(input.toPath());
                for (File library : inputDependencies) {
                    remapper.readClassPath(library.toPath());
                }
                remapper.apply(consumer);
            }
            finally {
                remapper.finish();
                System.out.println();
            }
        }
        catch (IOException e) {
            throw new GradleException("Could not remap Quiltflower from " + input.getName() + " to " + output.getName(), (Throwable)e);
        }
    }
}

