/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl;

import juuxel.loomquiltflower.api.QuiltflowerExtension;
import juuxel.loomquiltflower.api.QuiltflowerPreferences;
import juuxel.loomquiltflower.api.QuiltflowerSource;
import juuxel.loomquiltflower.api.SourceFactory;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;

public class DeprecatedQuiltflowerExtension
implements QuiltflowerExtension {
    private final Project project;
    private final QuiltflowerExtension parent;
    private boolean reported = false;

    public DeprecatedQuiltflowerExtension(Project project, QuiltflowerExtension parent) {
        this.project = project;
        this.parent = parent;
    }

    private void reportDeprecation() {
        if (!this.reported) {
            String message = "'loomQuiltflower' has been replaced by 'quiltflower' and will be removed in a future release";
            switch (this.project.getGradle().getStartParameter().getWarningMode()) {
                case Fail: {
                    throw new UnsupportedOperationException(message);
                }
                case None: {
                    break;
                }
                default: {
                    this.project.getLogger().warn(message);
                }
            }
            this.reported = true;
        }
    }

    @Override
    public Property<String> getQuiltflowerVersion() {
        this.reportDeprecation();
        return this.parent.getQuiltflowerVersion();
    }

    @Override
    public Property<QuiltflowerSource> getSource() {
        this.reportDeprecation();
        return this.parent.getSource();
    }

    @Override
    public SourceFactory getSourceFactory() {
        this.reportDeprecation();
        return this.parent.getSourceFactory();
    }

    @Override
    public void fromLatestQuiltSnapshot() {
        this.reportDeprecation();
        this.parent.fromLatestQuiltSnapshot();
    }

    @Override
    public QuiltflowerPreferences getPreferences() {
        this.reportDeprecation();
        return this.parent.getPreferences();
    }

    @Override
    public Property<Boolean> getAddToRuntimeClasspath() {
        this.reportDeprecation();
        return this.parent.getAddToRuntimeClasspath();
    }
}

