/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import juuxel.loomquiltflower.api.QuiltflowerExtension;
import juuxel.loomquiltflower.api.QuiltflowerPreferences;
import juuxel.loomquiltflower.api.QuiltflowerSource;
import juuxel.loomquiltflower.api.SourceFactory;
import juuxel.loomquiltflower.impl.module.LqfModule;
import juuxel.loomquiltflower.impl.source.ConstantUrlQuiltflowerSource;
import juuxel.loomquiltflower.impl.source.QuiltMavenQuiltflowerSource;
import juuxel.loomquiltflower.impl.source.RepositoryQuiltflowerSource;
import org.gradle.api.Project;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.Nullable;

public class QuiltflowerExtensionImpl
implements QuiltflowerExtension {
    private final Project project;
    private final Property<String> quiltflowerVersion;
    private final Property<QuiltflowerSource> source;
    private final SourceFactory sourceFactory = new SourceFactoryImpl();
    private final MapProperty<String, Object> preferenceMap;
    private final QuiltflowerPreferences preferences;
    private final Property<Boolean> addToRuntimeClasspath;
    private final Path cache;
    private LqfModule activeModule;

    public QuiltflowerExtensionImpl(Project project) {
        this.project = project;
        this.quiltflowerVersion = project.getObjects().property(String.class).convention((Object)"1.9.0");
        this.source = project.getObjects().property(QuiltflowerSource.class).convention((Object)this.sourceFactory.fromQuiltMaven((Provider<String>)this.quiltflowerVersion));
        this.preferenceMap = project.getObjects().mapProperty(String.class, Object.class).empty();
        this.preferences = (QuiltflowerPreferences)project.getObjects().newInstance(PreferencesImpl.class, new Object[]{this});
        this.addToRuntimeClasspath = project.getObjects().property(Boolean.class).convention((Object)false);
        this.cache = project.file((Object)".gradle/loom-quiltflower-cache").toPath();
    }

    public LqfModule getActiveModule() {
        if (this.activeModule == null) {
            throw new IllegalStateException("loom-quiltflower module not initialised. Please report this!");
        }
        return this.activeModule;
    }

    public void setActiveModule(LqfModule activeModule) {
        this.activeModule = activeModule;
    }

    public Path getCache() {
        if (Files.notExists(this.cache, new LinkOption[0])) {
            try {
                Files.createDirectories(this.cache, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not create cache at " + this.cache.toAbsolutePath(), e);
            }
        }
        return this.cache;
    }

    @Override
    public Property<String> getQuiltflowerVersion() {
        return this.quiltflowerVersion;
    }

    @Override
    public Property<QuiltflowerSource> getSource() {
        return this.source;
    }

    @Override
    public SourceFactory getSourceFactory() {
        return this.sourceFactory;
    }

    @Override
    public void fromLatestQuiltSnapshot() {
        Provider latestSnapshotVersion = this.project.provider(QuiltMavenQuiltflowerSource::findLatestSnapshot);
        this.getSource().set((Object)this.getSourceFactory().fromQuiltSnapshotMaven((Provider<String>)latestSnapshotVersion));
    }

    @Override
    public QuiltflowerPreferences getPreferences() {
        return this.preferences;
    }

    @Override
    public Property<Boolean> getAddToRuntimeClasspath() {
        return this.addToRuntimeClasspath;
    }

    private final class SourceFactoryImpl
    implements SourceFactory {
        private SourceFactoryImpl() {
        }

        @Override
        public QuiltflowerSource fromFile(Object path) {
            return this.fromUrl(QuiltflowerExtensionImpl.this.project.file(path));
        }

        @Override
        public QuiltflowerSource fromUrl(Object url) {
            try {
                return new ConstantUrlQuiltflowerSource(QuiltflowerExtensionImpl.this.project.uri(url).toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Malformed url: " + url, e);
            }
        }

        @Override
        public QuiltflowerSource fromProjectRepositories(Provider<String> version) {
            return new RepositoryQuiltflowerSource(QuiltflowerExtensionImpl.this.project, version);
        }

        @Override
        public QuiltflowerSource fromDependency(Object dependencyNotation) {
            return new RepositoryQuiltflowerSource(QuiltflowerExtensionImpl.this.project, dependencyNotation);
        }

        @Override
        public QuiltflowerSource fromQuiltMaven(Provider<String> version) {
            return new QuiltMavenQuiltflowerSource(version, QuiltMavenQuiltflowerSource.Repository.RELEASE);
        }

        @Override
        public QuiltflowerSource fromQuiltSnapshotMaven(Provider<String> version) {
            return new QuiltMavenQuiltflowerSource(version, QuiltMavenQuiltflowerSource.Repository.SNAPSHOT);
        }
    }

    public static class PreferencesImpl
    implements QuiltflowerPreferences {
        private final QuiltflowerExtensionImpl extension;

        @Inject
        public PreferencesImpl(QuiltflowerExtensionImpl extension) {
            this.extension = extension;
        }

        @Override
        public MapProperty<String, Object> asMap() {
            return this.extension.preferenceMap;
        }

        @Override
        public Provider<Map<String, String>> asStringMap() {
            return this.asMap().map(map -> {
                HashMap output = new HashMap();
                map.forEach((key, value) -> {
                    if (value instanceof Boolean) {
                        value = (Boolean)value != false ? "1" : "0";
                    }
                    output.put(key, String.valueOf(value));
                });
                return output;
            });
        }

        @Nullable
        public Object propertyMissing(String key) {
            return this.get(key);
        }

        public void propertyMissing(String key, Object value) {
            this.set(key, value);
        }
    }
}

