/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;

public final class ReflectionUtil {
    public static <T> T getFieldOrRecordComponent(Object o, String name) {
        Class<?> c = o.getClass();
        try {
            try {
                Method accessor = c.getMethod(name, new Class[0]);
                return (T)accessor.invoke(o, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                Field field = c.getField(name);
                return (T)field.get(o);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not find property " + name + " in " + c, e);
        }
    }

    public static <T> Optional<T> maybeGetFieldOrRecordComponent(Object o, String name) {
        Class<?> c = o.getClass();
        try {
            try {
                Method accessor = c.getMethod(name, new Class[0]);
                return Optional.ofNullable(accessor.invoke(o, new Object[0]));
            }
            catch (NoSuchMethodException e) {
                try {
                    Field field = c.getField(name);
                    return Optional.ofNullable(field.get(o));
                }
                catch (NoSuchFieldException f) {
                    return Optional.empty();
                }
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not find property " + name + " in " + c, e);
        }
    }

    public static boolean classExists(String fqn) {
        try {
            Class.forName(fqn);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> Optional<T> maybeInvokeNoArgsMethod(Object o, String name) {
        try {
            return Optional.ofNullable(o.getClass().getMethod(name, new Class[0]).invoke(o, new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            return Optional.empty();
        }
    }
}

