/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.bridge;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import juuxel.loomquiltflower.impl.relocated.quiltflower.main.DecompilerContext;
import juuxel.loomquiltflower.impl.relocated.quiltflowerapi.IFabricResultSaver;

public class QfResultSaver
implements IFabricResultSaver {
    private final Supplier<File> output;
    private final Supplier<File> lineMapFile;
    public Map<String, ZipOutputStream> outputStreams = new HashMap<String, ZipOutputStream>();
    public Map<String, ExecutorService> saveExecutors = new HashMap<String, ExecutorService>();
    public PrintWriter lineMapWriter;

    public QfResultSaver(Supplier<File> output, Supplier<File> lineMapFile) {
        this.output = output;
        this.lineMapFile = lineMapFile;
    }

    public void createArchive(String path, String archiveName, Manifest manifest) {
        String key = path + "/" + archiveName;
        File file = this.output.get();
        try {
            FileOutputStream fos = new FileOutputStream(file);
            ZipOutputStream zos = manifest == null ? new ZipOutputStream(fos) : new JarOutputStream((OutputStream)fos, manifest);
            this.outputStreams.put(key, zos);
            this.saveExecutors.put(key, Executors.newSingleThreadExecutor());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create archive: " + file, e);
        }
        if (this.lineMapFile.get() != null) {
            try {
                this.lineMapWriter = new PrintWriter(new FileWriter(this.lineMapFile.get()));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create line mapping file: " + this.lineMapFile.get(), e);
            }
        }
    }

    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content) {
        this.saveClassEntry(path, archiveName, qualifiedName, entryName, content, null);
    }

    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content, int[] mapping) {
        String key = path + "/" + archiveName;
        ExecutorService executor = this.saveExecutors.get(key);
        executor.submit(() -> {
            ZipOutputStream zos = this.outputStreams.get(key);
            try {
                zos.putNextEntry(new ZipEntry(entryName));
                if (content != null) {
                    zos.write(content.getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                DecompilerContext.getLogger().writeMessage("Cannot write entry " + entryName, (Throwable)e);
            }
            if (mapping != null && this.lineMapWriter != null) {
                int maxLine = 0;
                int maxLineDest = 0;
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < mapping.length; i += 2) {
                    maxLine = Math.max(maxLine, mapping[i]);
                    maxLineDest = Math.max(maxLineDest, mapping[i + 1]);
                    builder.append("\t").append(mapping[i]).append("\t").append(mapping[i + 1]).append("\n");
                }
                this.lineMapWriter.println(qualifiedName + "\t" + maxLine + "\t" + maxLineDest);
                this.lineMapWriter.println(builder.toString());
            }
        });
    }

    public void closeArchive(String path, String archiveName) {
        String key = path + "/" + archiveName;
        ExecutorService executor = this.saveExecutors.get(key);
        Future<?> closeFuture = executor.submit(() -> {
            ZipOutputStream zos = this.outputStreams.get(key);
            try {
                zos.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close zip. " + key, e);
            }
        });
        executor.shutdown();
        try {
            closeFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.outputStreams.remove(key);
        this.saveExecutors.remove(key);
        if (this.lineMapWriter != null) {
            this.lineMapWriter.flush();
            this.lineMapWriter.close();
        }
    }

    public void saveFolder(String path) {
    }

    public void copyFile(String source, String path, String entryName) {
    }

    public void saveClassFile(String path, String qualifiedName, String entryName, String content, int[] mapping) {
    }

    public void saveDirEntry(String path, String archiveName, String entryName) {
    }

    public void copyEntry(String source, String path, String archiveName, String entry) {
    }
}

