/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.bridge;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Stack;
import juuxel.loomquiltflower.impl.relocated.quiltflower.main.extern.IFernflowerLogger;

public class QfThreadIdLogger
extends IFernflowerLogger {
    public final PrintStream stdOut;
    public final PrintStream stdErr;
    private final ThreadLocal<Stack<String>> workingClass = ThreadLocal.withInitial(Stack::new);
    private final ThreadLocal<Stack<String>> line = ThreadLocal.withInitial(Stack::new);

    public QfThreadIdLogger() {
        this(System.err, System.out);
    }

    public QfThreadIdLogger(PrintStream stdOut, PrintStream stdErr) {
        this.stdOut = stdOut;
        this.stdErr = stdErr;
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity) {
        System.err.println(message);
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t) {
        System.err.println(message);
        t.printStackTrace(System.err);
    }

    private void print() {
        Thread thread = Thread.currentThread();
        long id = thread.getId();
        if (this.line.get().isEmpty()) {
            System.out.println(MessageFormat.format("{0} :: waiting", id));
            return;
        }
        String line = this.line.get().peek();
        System.out.println(MessageFormat.format("{0} :: {1}", id, line).trim());
    }

    public void startReadingClass(String className) {
        this.workingClass.get().push(className);
        this.line.get().push("Decompiling " + className);
        this.print();
    }

    public void startClass(String className) {
        this.workingClass.get().push(className);
        this.line.get().push("Decompiling " + className);
        this.print();
    }

    public void startMethod(String methodName) {
    }

    public void endMethod() {
    }

    public void endClass() {
        this.line.get().pop();
        this.workingClass.get().pop();
        this.print();
    }

    public void startWriteClass(String className) {
        this.line.get().push("Writing " + className);
        this.print();
    }

    public void endWriteClass() {
        this.line.get().pop();
        this.print();
    }

    public void endReadingClass() {
        this.line.get().pop();
        this.workingClass.get().pop();
        this.print();
    }
}

