/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.bridge;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import juuxel.loomquiltflower.impl.relocated.mappingio.MappingReader;
import juuxel.loomquiltflower.impl.relocated.mappingio.MappingVisitor;
import juuxel.loomquiltflower.impl.relocated.mappingio.adapter.MappingSourceNsSwitch;
import juuxel.loomquiltflower.impl.relocated.mappingio.tree.MappingTree;
import juuxel.loomquiltflower.impl.relocated.mappingio.tree.MemoryMappingTree;
import juuxel.loomquiltflower.impl.relocated.quiltflower.struct.StructClass;
import juuxel.loomquiltflower.impl.relocated.quiltflower.struct.StructField;
import juuxel.loomquiltflower.impl.relocated.quiltflower.struct.StructMethod;
import juuxel.loomquiltflower.impl.relocated.quiltflower.struct.StructRecordComponent;
import juuxel.loomquiltflower.impl.relocated.quiltflowerapi.IFabricJavadocProvider;

public class QfTinyJavadocProvider
implements IFabricJavadocProvider {
    private final MappingTree mappingTree;
    private final String namespace = "named";

    public QfTinyJavadocProvider(File tinyFile) {
        this.mappingTree = this.readMappings(tinyFile);
    }

    public String getClassDoc(StructClass structClass) {
        MappingTree.ClassMapping classMapping = this.mappingTree.getClass(structClass.qualifiedName);
        if (classMapping == null) {
            return null;
        }
        if (!QfTinyJavadocProvider.isRecord(structClass)) {
            return classMapping.getComment();
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (classMapping.getComment() != null) {
            parts.add(classMapping.getComment());
        }
        boolean addedParam = false;
        for (StructRecordComponent component : structClass.getRecordComponents()) {
            String comment;
            MappingTree.FieldMapping fieldMapping = classMapping.getField(component.getName(), component.getDescriptor());
            if (fieldMapping == null || (comment = fieldMapping.getComment()) == null) continue;
            if (!addedParam && classMapping.getComment() != null) {
                parts.add("");
                addedParam = true;
            }
            parts.add(String.format("@param %s %s", fieldMapping.getName("named"), comment));
        }
        if (parts.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)"\n", parts);
    }

    public String getFieldDoc(StructClass structClass, StructField structField) {
        if (QfTinyJavadocProvider.isRecord(structClass) && !QfTinyJavadocProvider.isStatic(structField)) {
            return null;
        }
        MappingTree.ClassMapping classMapping = this.mappingTree.getClass(structClass.qualifiedName);
        if (classMapping == null) {
            return null;
        }
        MappingTree.FieldMapping fieldMapping = classMapping.getField(structField.getName(), structField.getDescriptor());
        return fieldMapping != null ? fieldMapping.getComment() : null;
    }

    public String getMethodDoc(StructClass structClass, StructMethod structMethod) {
        MappingTree.ClassMapping classMapping = this.mappingTree.getClass(structClass.qualifiedName);
        if (classMapping == null) {
            return null;
        }
        MappingTree.MethodMapping methodMapping = classMapping.getMethod(structMethod.getName(), structMethod.getDescriptor());
        if (methodMapping != null) {
            ArrayList<String> parts = new ArrayList<String>();
            if (methodMapping.getComment() != null) {
                parts.add(methodMapping.getComment());
            }
            boolean addedParam = false;
            for (MappingTree.MethodArgMapping methodArgMapping : methodMapping.getArgs()) {
                String comment = methodArgMapping.getComment();
                if (comment == null) continue;
                if (!addedParam && methodMapping.getComment() != null) {
                    parts.add("");
                    addedParam = true;
                }
                parts.add(String.format("@param %s %s", methodArgMapping.getName("named"), comment));
            }
            if (parts.isEmpty()) {
                return null;
            }
            return String.join((CharSequence)"\n", parts);
        }
        return null;
    }

    private MappingTree readMappings(File input) {
        MemoryMappingTree memoryMappingTree;
        block8: {
            BufferedReader reader = Files.newBufferedReader(input.toPath());
            try {
                MemoryMappingTree mappingTree = new MemoryMappingTree();
                MappingSourceNsSwitch nsSwitch = new MappingSourceNsSwitch(mappingTree, "named");
                MappingReader.read(reader, (MappingVisitor)nsSwitch);
                memoryMappingTree = mappingTree;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read mappings", e);
                }
            }
            reader.close();
        }
        return memoryMappingTree;
    }

    public static boolean isRecord(StructClass structClass) {
        return (structClass.getAccessFlags() & 0x10000) != 0;
    }

    public static boolean isStatic(StructField structField) {
        return (structField.getAccessFlags() & 8) != 0;
    }
}

