/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.bridge;

import java.io.PrintWriter;
import juuxel.loomquiltflower.impl.relocated.quiltflower.main.extern.IFernflowerLogger;

public class SimpleLogger
extends IFernflowerLogger {
    private final PrintWriter out;
    private final PrintWriter err;

    public SimpleLogger(PrintWriter out, PrintWriter err) {
        this.out = out;
        this.err = err;
    }

    public SimpleLogger(PrintWriter writer) {
        this(writer, writer);
    }

    private boolean acceptsSeverity(IFernflowerLogger.Severity severity) {
        return severity == IFernflowerLogger.Severity.ERROR || severity == IFernflowerLogger.Severity.WARN;
    }

    public void writeMessage(String s, IFernflowerLogger.Severity severity) {
        if (this.acceptsSeverity(severity)) {
            this.err.print(severity.prefix);
            this.err.println(s);
        }
    }

    public void writeMessage(String s, IFernflowerLogger.Severity severity, Throwable throwable) {
        if (throwable == null) {
            this.writeMessage(s, severity);
            return;
        }
        if (this.acceptsSeverity(severity)) {
            this.err.print(severity.prefix);
            this.err.print(s + ": ");
            throwable.printStackTrace();
        }
    }

    public void startReadingClass(String className) {
        this.out.println("Decompiling " + className);
    }

    public void startClass(String className) {
        this.out.println("Decompiling " + className);
    }
}

