/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.legacy;

import java.io.OutputStream;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Supplier;
import juuxel.loomquiltflower.impl.ReflectionUtil;
import juuxel.loomquiltflower.impl.SharedQfConfig;
import juuxel.loomquiltflower.impl.legacy.AbstractForkedFFExecutor;
import juuxel.loomquiltflower.impl.legacy.ForkingJavaExec;
import net.fabricmc.loom.api.decompilers.DecompilationMetadata;
import net.fabricmc.loom.api.decompilers.LoomDecompiler;
import net.fabricmc.loom.util.ConsumingOutputStream;
import net.fabricmc.loom.util.OperatingSystem;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;

public abstract class AbstractFernFlowerDecompiler
implements LoomDecompiler {
    private final Project project;

    protected AbstractFernFlowerDecompiler(Project project) {
        this.project = project;
    }

    public abstract Class<? extends AbstractForkedFFExecutor> fernFlowerExecutor();

    protected void configureJavaExec(JavaExecSpec spec) {
    }

    protected void configureOptions(Map<String, Object> options) {
    }

    public void decompile(Path compiledJar, Path sourcesDestination, Path linemapDestination, DecompilationMetadata metaData) {
        if (!OperatingSystem.is64Bit()) {
            throw new UnsupportedOperationException("FernFlower decompiler requires a 64bit JVM to run due to the memory requirements");
        }
        this.project.getLogging().captureStandardOutput(LogLevel.LIFECYCLE);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ind", "\t");
        this.configureOptions(options);
        SharedQfConfig.configureCommonOptions(options, metaData);
        for (Map.Entry entry : options.entrySet()) {
            if (!(entry.getValue() instanceof Boolean)) continue;
            entry.setValue((Boolean)entry.getValue() != false ? "1" : "0");
        }
        ArrayList<Object> args = new ArrayList<Object>();
        options.forEach((k, v) -> args.add(MessageFormat.format("-{0}={1}", k, v)));
        args.add(AbstractFernFlowerDecompiler.absolutePathOf(compiledJar));
        args.add("-o=" + AbstractFernFlowerDecompiler.absolutePathOf(sourcesDestination));
        args.add("-l=" + AbstractFernFlowerDecompiler.absolutePathOf(linemapDestination));
        args.add("-m=" + AbstractFernFlowerDecompiler.absolutePathOf((Path)ReflectionUtil.getFieldOrRecordComponent(metaData, "javaDocs")));
        for (Path library : (Collection)ReflectionUtil.getFieldOrRecordComponent(metaData, "libraries")) {
            args.add("-e=" + AbstractFernFlowerDecompiler.absolutePathOf(library));
        }
        ServiceRegistry serviceRegistry = ((ProjectInternal)this.project).getServices();
        ProgressLoggerFactory factory = (ProgressLoggerFactory)serviceRegistry.get(ProgressLoggerFactory.class);
        ProgressLogger progressGroup = factory.newOperation(this.getClass()).setDescription("Decompile");
        Supplier<ProgressLogger> loggerFactory = () -> {
            ProgressLogger pl = factory.newOperation(this.getClass(), progressGroup);
            pl.setDescription("decompile worker");
            pl.started();
            return pl;
        };
        Stack<ProgressLogger> freeLoggers = new Stack<ProgressLogger>();
        HashMap inUseLoggers = new HashMap();
        progressGroup.started();
        ExecResult result = ForkingJavaExec.javaexec(this.project, (Action<? super JavaExecSpec>)((Action)spec -> {
            spec.getMainClass().set((Object)this.fernFlowerExecutor().getName());
            spec.jvmArgs(new Object[]{"-Xms200m", "-Xmx3G"});
            spec.setArgs(args);
            spec.setErrorOutput((OutputStream)new ConsumingOutputStream(line -> {
                if (line.startsWith("Inconsistent inner class entries")) {
                    return;
                }
                System.err.println((String)line);
            }));
            spec.setStandardOutput((OutputStream)new ConsumingOutputStream(arg_0 -> AbstractFernFlowerDecompiler.lambda$decompile$3(inUseLoggers, freeLoggers, (Supplier)loggerFactory, arg_0)));
            this.configureJavaExec((JavaExecSpec)spec);
        }));
        inUseLoggers.values().forEach(ProgressLogger::completed);
        freeLoggers.forEach(ProgressLogger::completed);
        progressGroup.completed();
        result.rethrowFailure();
        result.assertNormalExitValue();
    }

    private static String absolutePathOf(Path path) {
        return path.toAbsolutePath().toString();
    }

    private static /* synthetic */ void lambda$decompile$3(Map inUseLoggers, Stack freeLoggers, Supplier loggerFactory, String line) {
        if (line.startsWith("Listening for transport") || !line.contains("::")) {
            System.out.println(line);
            return;
        }
        int sepIdx = line.indexOf("::");
        String id = line.substring(0, sepIdx).trim();
        String data = line.substring(sepIdx + 2).trim();
        ProgressLogger logger = (ProgressLogger)inUseLoggers.get(id);
        String[] segs = data.split(" ");
        if (segs[0].equals("waiting")) {
            if (logger != null) {
                logger.progress("Idle..");
                inUseLoggers.remove(id);
                freeLoggers.push(logger);
            }
        } else {
            if (logger == null) {
                logger = !freeLoggers.isEmpty() ? (ProgressLogger)freeLoggers.pop() : (ProgressLogger)loggerFactory.get();
                inUseLoggers.put(id, logger);
            }
            logger.progress(data);
        }
    }
}

