/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.modern;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import juuxel.loomquiltflower.impl.SharedQfConfig;
import juuxel.loomquiltflower.impl.Zips;
import juuxel.loomquiltflower.impl.bridge.QfResultSaver;
import juuxel.loomquiltflower.impl.bridge.QfTinyJavadocProvider;
import juuxel.loomquiltflower.impl.bridge.SimpleLogger;
import juuxel.loomquiltflower.impl.relocated.quiltflower.main.Fernflower;
import juuxel.loomquiltflower.impl.relocated.quiltflower.main.extern.IFernflowerLogger;
import juuxel.loomquiltflower.impl.relocated.quiltflower.main.extern.IResultSaver;
import net.fabricmc.loom.api.decompilers.DecompilationMetadata;
import net.fabricmc.loom.api.decompilers.LoomDecompiler;
import net.fabricmc.loom.util.IOStringConsumer;

public final class QuiltflowerDecompiler
implements LoomDecompiler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompile(Path compiledJar, Path sourcesDestination, Path linemapDestination, DecompilationMetadata metaData) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ind", "\t");
        SharedQfConfig.configureCommonOptions(options, metaData);
        options.put("fabric:javadoc", new QfTinyJavadocProvider(metaData.javaDocs().toFile()));
        PrintWriter logger = QuiltflowerDecompiler.writerFromLoomLogger(metaData.logger());
        Fernflower ff = new Fernflower(Zips::getBytes, (IResultSaver)new QfResultSaver(sourcesDestination::toFile, linemapDestination::toFile), options, (IFernflowerLogger)new SimpleLogger(logger));
        for (Path library : metaData.libraries()) {
            ff.addLibrary(library.toFile());
        }
        ff.addSource(compiledJar.toFile());
        try {
            ff.decompileContext();
        }
        finally {
            ff.clearContext();
        }
        this.closeFs(compiledJar);
    }

    private void closeFs(Path compiledJar) {
        try {
            FileSystems.getFileSystem(URI.create("jar:" + compiledJar.toUri())).close();
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not close file system " + compiledJar.toAbsolutePath(), e);
        }
    }

    private static PrintWriter writerFromLoomLogger(final IOStringConsumer logger) {
        Writer parent = new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                logger.accept(new String(cbuf, off, len));
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
        return new PrintWriter(parent);
    }
}

