/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.relocated.mappingio;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import juuxel.loomquiltflower.impl.relocated.mappingio.MappingVisitor;
import juuxel.loomquiltflower.impl.relocated.mappingio.format.EnigmaWriter;
import juuxel.loomquiltflower.impl.relocated.mappingio.format.MappingFormat;
import juuxel.loomquiltflower.impl.relocated.mappingio.format.Tiny2Writer;

public interface MappingWriter
extends Closeable,
MappingVisitor {
    public static MappingWriter create(Path file, MappingFormat format) throws IOException {
        if (format.hasSingleFile()) {
            return MappingWriter.create(Files.newBufferedWriter(file, new OpenOption[0]), format);
        }
        switch (format) {
            case ENIGMA: {
                return new EnigmaWriter(file, true);
            }
        }
        throw new UnsupportedOperationException("format " + (Object)((Object)format) + " is not implemented");
    }

    public static MappingWriter create(Writer writer, MappingFormat format) throws IOException {
        if (!format.hasSingleFile()) {
            throw new IllegalArgumentException("format " + (Object)((Object)format) + " is not applicable to a single writer");
        }
        switch (format) {
            case TINY_2: {
                return new Tiny2Writer(writer, false);
            }
        }
        throw new UnsupportedOperationException("format " + (Object)((Object)format) + " is not implemented");
    }
}

