/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.common;

public final class Logger {
    private final Level level;
    private static final boolean USE_ANSI = false;
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_BLACK = "\u001b[30m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_BLUE = "\u001b[34m";
    private static final String ANSI_PURPLE = "\u001b[35m";
    private static final String ANSI_CYAN = "\u001b[36m";
    private static final String ANSI_WHITE = "\u001b[37m";

    public Logger(Level level) {
        this.level = level;
    }

    public void info(String message) {
        if (this.level.compareTo(Level.INFO) <= 0) {
            System.out.println("[INFO]  [MIXIN] " + message);
        }
    }

    public void warn(String message) {
        if (this.level.compareTo(Level.WARN) <= 0) {
            System.out.println("[WARN]  [MIXIN] " + message);
        }
    }

    public void error(String message) {
        if (this.level.compareTo(Level.ERROR) <= 0) {
            System.out.println("[ERROR] [MIXIN] " + message);
        }
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

