/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.hard.annotation;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.common.data.CommonData;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.common.data.MxMember;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.hard.util.CamelPrefixString;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.hard.util.ConvertibleMappable;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.hard.util.IConvertibleString;
import org.objectweb.asm.AnnotationVisitor;

public class InvokerAnnotationVisitor
extends AnnotationVisitor {
    private final List<Consumer<CommonData>> tasks;
    private final MxMember method;
    private final List<String> targets;
    private boolean remap;
    private boolean isSoftTarget;

    public InvokerAnnotationVisitor(List<Consumer<CommonData>> tasks, AnnotationVisitor delegate, MxMember method, boolean remap, List<String> targets) {
        super(589824, delegate);
        this.tasks = Objects.requireNonNull(tasks);
        this.method = Objects.requireNonNull(method);
        this.targets = Objects.requireNonNull(targets);
        this.remap = remap;
        this.isSoftTarget = false;
    }

    public void visit(String name, Object value) {
        if (name.equals("remap")) {
            this.remap = Objects.requireNonNull((Boolean)value);
        } else if (name.equals("value")) {
            this.isSoftTarget = true;
        }
        super.visit(name, value);
    }

    public void visitEnd() {
        if (this.remap && !this.isSoftTarget) {
            this.tasks.add(data -> new InvokerMappable((CommonData)data, this.method, (Collection<String>)this.targets).result());
        }
        super.visitEnd();
    }

    private static class InvokerMappable
    extends ConvertibleMappable {
        private final String prefix;

        InvokerMappable(CommonData data, MxMember self, Collection<String> targets) {
            super(data, self, targets);
            if (self.getName().startsWith("call")) {
                this.prefix = "call";
            } else if (self.getName().startsWith("invoke")) {
                this.prefix = "invoke";
            } else if (self.getName().startsWith("new")) {
                this.prefix = "new";
            } else if (self.getName().startsWith("create")) {
                this.prefix = "create";
            } else {
                throw new RuntimeException(String.format("%s does not start with call or invoke.", self.getName()));
            }
        }

        @Override
        protected IConvertibleString getName() {
            return new CamelPrefixString(this.prefix, this.self.getName());
        }

        @Override
        protected String getDesc() {
            return this.self.getDesc();
        }
    }
}

