/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.hard.util;

import java.util.Objects;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.common.StringUtility;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.hard.util.IConvertibleString;

public class CamelPrefixString
implements IConvertibleString {
    private final String prefix;
    private final String text;

    public CamelPrefixString(String prefix, String text) {
        this.prefix = Objects.requireNonNull(prefix);
        this.text = StringUtility.removeCamelPrefix(prefix, text);
    }

    @Override
    public String getOriginal() {
        return StringUtility.addCamelPrefix(this.prefix, this.text);
    }

    @Override
    public String getConverted() {
        return this.text;
    }

    @Override
    public String getReverted(String newText) {
        return StringUtility.addCamelPrefix(this.prefix, newText);
    }
}

