/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.soft.annotation.injection;

import java.util.Objects;
import java.util.Optional;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.api.TrMember;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.common.IMappable;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.common.ResolveUtility;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.common.data.CommonData;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.soft.annotation.FirstPassAnnotationVisitor;
import juuxel.loomquiltflower.impl.relocated.tinyremapper.extension.mixin.soft.data.MemberInfo;
import org.objectweb.asm.AnnotationVisitor;

class AtAnnotationVisitor
extends FirstPassAnnotationVisitor {
    private final CommonData data;
    private final AnnotationVisitor delegate;
    private String value;

    AtAnnotationVisitor(CommonData data, AnnotationVisitor delegate, boolean remap) {
        super("Lorg/spongepowered/asm/mixin/injection/At;", remap);
        this.data = Objects.requireNonNull(data);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void visit(String name, Object value) {
        if (name.equals("value")) {
            this.value = Objects.requireNonNull((String)value);
        }
        super.visit(name, value);
    }

    public void visitEnd() {
        if (this.remap) {
            this.accept(new AtSecondPassAnnotationVisitor(this.data, this.delegate, this.value));
        } else {
            this.accept(this.delegate);
        }
        super.visitEnd();
    }

    private static class AtSecondPassAnnotationVisitor
    extends AnnotationVisitor {
        private final CommonData data;
        private final String value;

        AtSecondPassAnnotationVisitor(CommonData data, AnnotationVisitor delegate, String value) {
            super(589824, delegate);
            this.data = Objects.requireNonNull(data);
            this.value = Objects.requireNonNull(value);
        }

        public void visit(String name, Object value) {
            MemberInfo info;
            if (name.equals("target") && (info = MemberInfo.parse(Objects.requireNonNull((String)value).replaceAll("\\s", ""))) != null) {
                value = this.value.equals("NEW") ? new AtConstructorMappable(this.data, info).result().toString() : new AtMethodMappable(this.data, info).result().toString();
            }
            super.visit(name, value);
        }

        public AnnotationVisitor visitArray(String name) {
            AnnotationVisitor av = super.visitArray(name);
            if (name.equals("args") && this.value.equals("NEW")) {
                String prefix = "class=";
                av = new AnnotationVisitor(589824, av){

                    public void visit(String name, Object value) {
                        MemberInfo info;
                        String argument = Objects.requireNonNull((String)value);
                        if (argument.startsWith("class=") && (info = MemberInfo.parse(argument.substring("class=".length()).replaceAll("\\s", ""))) != null) {
                            value = "class=" + new AtConstructorMappable(data, info).result().toString();
                        }
                        super.visit(name, value);
                    }
                };
            }
            return av;
        }
    }

    private static class AtConstructorMappable
    implements IMappable<MemberInfo> {
        private final CommonData data;
        private final MemberInfo info;

        AtConstructorMappable(CommonData data, MemberInfo info) {
            this.data = Objects.requireNonNull(data);
            this.info = Objects.requireNonNull(info);
        }

        @Override
        public MemberInfo result() {
            if (this.info.getDesc().isEmpty()) {
                return new MemberInfo(this.data.mapper.asTrRemapper().map(this.info.getOwner()), this.info.getName(), this.info.getQuantifier(), "");
            }
            if (this.info.getDesc().endsWith(")V")) {
                return new MemberInfo(this.data.mapper.asTrRemapper().map(this.info.getOwner()), this.info.getName(), this.info.getQuantifier(), this.data.mapper.asTrRemapper().mapMethodDesc(this.info.getDesc()));
            }
            return new MemberInfo(this.info.getOwner(), this.info.getName(), this.info.getQuantifier(), this.data.mapper.asTrRemapper().mapMethodDesc(this.info.getDesc()));
        }
    }

    private static class AtMethodMappable
    implements IMappable<MemberInfo> {
        private final CommonData data;
        private final MemberInfo info;

        AtMethodMappable(CommonData data, MemberInfo info) {
            this.data = Objects.requireNonNull(data);
            this.info = Objects.requireNonNull(info);
        }

        @Override
        public MemberInfo result() {
            if (!this.info.isFullyQualified()) {
                this.data.logger.warn(String.format("%s is not fully qualified.", this.info));
                return this.info;
            }
            Optional<TrMember> resolved = this.data.resolver.resolveMember(this.info.getOwner(), this.info.getName(), this.info.getDesc(), ResolveUtility.FLAG_UNIQUE | ResolveUtility.FLAG_RECURSIVE);
            if (resolved.isPresent()) {
                String newOwner = this.data.mapper.asTrRemapper().map(this.info.getOwner());
                String newName = this.data.mapper.mapName(resolved.get());
                String newDesc = this.data.mapper.mapDesc(resolved.get());
                return new MemberInfo(newOwner, newName, this.info.getQuantifier(), newDesc);
            }
            return this.info;
        }
    }
}

