/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.source;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import juuxel.loomquiltflower.api.QuiltflowerSource;
import org.gradle.api.provider.Provider;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class QuiltMavenQuiltflowerSource
implements QuiltflowerSource {
    private static final String RELEASE_URL = "https://maven.quiltmc.org/repository/release";
    private static final String SNAPSHOT_URL = "https://maven.quiltmc.org/repository/snapshot";
    @Language(value="XPath")
    private static final String LATEST_VERSION_XPATH = "/metadata/versioning/latest/text()";
    @Language(value="XPath")
    private static final String SNAPSHOT_VERSION_XPATH = "/metadata/versioning/snapshotVersions/snapshotVersion[not(classifier) and extension=\"jar\"]/value/text()";
    private final Provider<String> version;
    private final Repository repository;
    @Nullable
    private String artifactVersion;

    public QuiltMavenQuiltflowerSource(Provider<String> version, Repository repository) {
        this.version = version;
        this.repository = repository;
    }

    @Override
    public InputStream open() throws IOException {
        String baseVersion = (String)this.version.get();
        String artifactVersion = this.getResolvedVersion();
        URL url = new URL("%s/org/quiltmc/quiltflower/%s/quiltflower-%s.jar".formatted(this.repository.url, baseVersion, artifactVersion));
        return url.openStream();
    }

    @Override
    public String getProvidedVersion() {
        return (String)this.version.get();
    }

    @Override
    public String getResolvedVersion() throws IOException {
        if (this.artifactVersion == null) {
            this.artifactVersion = this.computeArtifactVersion();
            return this.artifactVersion;
        }
        return this.artifactVersion;
    }

    private String computeArtifactVersion() throws IOException {
        String snapshot;
        String baseVersion = (String)this.version.get();
        if (baseVersion.endsWith("-SNAPSHOT") && (snapshot = QuiltMavenQuiltflowerSource.findLatestSnapshot(this.repository, baseVersion)) != null) {
            return snapshot;
        }
        return baseVersion;
    }

    public String toString() {
        return "fromQuiltMaven";
    }

    public static String findLatestSnapshot() throws Exception {
        String url = "%s/org/quiltmc/quiltflower/maven-metadata.xml".formatted(SNAPSHOT_URL);
        Document document = QuiltMavenQuiltflowerSource.readXmlDocument(url);
        return QuiltMavenQuiltflowerSource.getLatestVersion(document, url);
    }

    @VisibleForTesting
    public static String getLatestVersion(Document document, Object url) {
        String version = QuiltMavenQuiltflowerSource.queryXpath(LATEST_VERSION_XPATH, document);
        if (version == null) {
            throw new NoSuchElementException("Could not find latest version in maven-metadata.xml (" + url + ")");
        }
        return version;
    }

    private static Document readXmlDocument(String url) throws IOException {
        Document document;
        block8: {
            InputStream in = new URL(url).openStream();
            try {
                document = DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder().parse(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("Could not read maven-metadata.xml for Quiltflower snapshots (" + url + ")", e);
                }
            }
            in.close();
        }
        return document;
    }

    @Nullable
    private static String queryXpath(@Language(value="XPath") String expression, Node context) {
        XPathFactory factory = XPathFactory.newDefaultInstance();
        XPath xp = factory.newXPath();
        try {
            String value = xp.evaluate(expression, context);
            return !value.isEmpty() ? value : null;
        }
        catch (XPathException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static String findLatestSnapshot(Repository repository, String baseVersion) throws IOException {
        Document document = QuiltMavenQuiltflowerSource.readXmlDocument("%s/org/quiltmc/quiltflower/%s/maven-metadata.xml".formatted(repository.url, baseVersion));
        return QuiltMavenQuiltflowerSource.findLatestSnapshot(document);
    }

    @VisibleForTesting
    @Nullable
    public static String findLatestSnapshot(Document document) {
        return QuiltMavenQuiltflowerSource.queryXpath(SNAPSHOT_VERSION_XPATH, document);
    }

    public static enum Repository {
        RELEASE("https://maven.quiltmc.org/repository/release"),
        SNAPSHOT("https://maven.quiltmc.org/repository/snapshot");

        private final String url;

        private Repository(String url) {
            this.url = url;
        }
    }
}

