/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import juuxel.loomquiltflower.api.QuiltflowerSource;
import juuxel.loomquiltflower.impl.ReflectionUtil;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.Nullable;

public final class RepositoryQuiltflowerSource
implements QuiltflowerSource {
    private static final String DEPENDENCY_BASE = "org.quiltmc:quiltflower:";
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private final Project project;
    private final Object dependencyNotation;
    @Nullable
    private Dependency dependency = null;
    @Nullable
    private File quiltflowerFile = null;
    @Nullable
    private String resolvedVersion = null;

    public RepositoryQuiltflowerSource(Project project, Provider<String> version) {
        this.project = project;
        this.dependencyNotation = version.map(it -> DEPENDENCY_BASE + it);
    }

    public RepositoryQuiltflowerSource(Project project, Object dependencyNotation) {
        this.project = project;
        this.dependencyNotation = dependencyNotation;
    }

    private Dependency getDependency() {
        if (this.dependency == null) {
            this.dependency = this.project.getDependencies().create(RepositoryQuiltflowerSource.unwrapPossibleProviders(this.dependencyNotation));
        }
        return this.dependency;
    }

    private static Object unwrapPossibleProviders(Object o) {
        while (o instanceof Provider) {
            o = ((Provider)o).get();
        }
        return o;
    }

    private void resolve() {
        if (this.quiltflowerFile == null) {
            Set files;
            Dependency dependency = this.getDependency();
            Object version = dependency.getVersion();
            if (dependency instanceof SelfResolvingDependency) {
                files = ((SelfResolvingDependency)dependency).resolve();
            } else {
                Configuration configuration = this.project.getConfigurations().detachedConfiguration(new Dependency[]{dependency});
                ResolvedConfiguration resolved = configuration.getResolvedConfiguration();
                @Nullable String baseVersion = dependency.getVersion();
                if (baseVersion != null && baseVersion.endsWith(SNAPSHOT_SUFFIX)) {
                    for (ResolvedArtifact artifact : resolved.getResolvedArtifacts()) {
                        ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
                        if (!Objects.equals(id.getGroup(), dependency.getGroup()) || !Objects.equals(id.getName(), dependency.getName())) continue;
                        ComponentIdentifier componentId = artifact.getId().getComponentIdentifier();
                        Optional timestamp = ReflectionUtil.maybeInvokeNoArgsMethod(componentId, "getTimestamp");
                        if (!timestamp.isPresent()) break;
                        version = baseVersion.substring(0, baseVersion.length() - SNAPSHOT_SUFFIX.length() + 1) + timestamp.get();
                        break;
                    }
                }
                files = resolved.getFiles();
            }
            if (files.size() == 0) {
                throw new GradleException("Could not resolve Quiltflower " + dependency + " from repositories!");
            }
            if (files.size() > 1) {
                throw new GradleException("Found more than 1 Quiltflower jar: " + files.stream().map(File::getAbsolutePath).collect(Collectors.joining(", ")));
            }
            this.quiltflowerFile = (File)files.iterator().next();
            this.resolvedVersion = version;
        }
    }

    @Override
    public InputStream open() throws IOException {
        this.resolve();
        return new FileInputStream(this.quiltflowerFile);
    }

    @Override
    @Nullable
    public String getProvidedVersion() {
        return this.getDependency().getVersion();
    }

    @Override
    @Nullable
    public String getResolvedVersion() {
        this.resolve();
        return this.resolvedVersion;
    }

    public String toString() {
        return "fromDependency(" + this.dependencyNotation + ")";
    }
}

