/*
 * Decompiled with CFR 0.152.
 */
package juuxel.loomquiltflower.impl.task;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import juuxel.loomquiltflower.api.QuiltflowerSource;
import juuxel.loomquiltflower.core.Remapping;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ResolveQuiltflower
extends DefaultTask {
    private final Property<QuiltflowerSource> source = this.getProject().getObjects().property(QuiltflowerSource.class);
    private final RegularFileProperty unprocessedOutput = this.getProject().getObjects().fileProperty();
    private final RegularFileProperty remappedOutput = this.getProject().getObjects().fileProperty();

    public ResolveQuiltflower() {
        this.getOutputs().upToDateWhen(t -> !this.getProject().getGradle().getStartParameter().isRefreshDependencies() && !Boolean.getBoolean("loom-quiltflower.refresh"));
    }

    @Internal
    public Property<QuiltflowerSource> getSource() {
        return this.source;
    }

    @OutputFile
    public RegularFileProperty getUnprocessedOutput() {
        return this.unprocessedOutput;
    }

    @OutputFile
    public RegularFileProperty getRemappedOutput() {
        return this.remappedOutput;
    }

    @TaskAction
    public void resolve() throws IOException {
        QuiltflowerSource source = (QuiltflowerSource)this.source.get();
        File unprocessedOutput = ((RegularFile)this.unprocessedOutput.get()).getAsFile();
        try (InputStream in = source.open();){
            Files.copy(in, unprocessedOutput.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new IOException("Source " + source + " could not resolve Quiltflower", e);
        }
        File output = ((RegularFile)this.remappedOutput.get()).getAsFile();
        Path outputPath = output.toPath();
        Path parent = outputPath.getParent();
        if (Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectory(parent, new FileAttribute[0]);
        } else {
            Files.deleteIfExists(outputPath);
        }
        Remapping.remapQuiltflower(unprocessedOutput, output, Collections.emptySet());
    }
}

