/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.SeverityLevel;
import io.gitlab.arturbosch.detekt.api.SourceLocation;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010!\u001a\u00020\u0007H\u0016J\b\u0010\"\u001a\u00020\u0007H\u0016J\b\u0010#\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0014\u0010\u001f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013\u00a8\u0006%"}, d2={"Lio/gitlab/arturbosch/detekt/api/CodeSmell;", "Lio/gitlab/arturbosch/detekt/api/Finding;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "entity", "Lio/gitlab/arturbosch/detekt/api/Entity;", "message", "", "metrics", "", "Lio/gitlab/arturbosch/detekt/api/Metric;", "references", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Issue;Lio/gitlab/arturbosch/detekt/api/Entity;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "getEntity", "()Lio/gitlab/arturbosch/detekt/api/Entity;", "getMessage", "()Ljava/lang/String;", "getMetrics", "()Ljava/util/List;", "getReferences", "internalSeverity", "Lio/gitlab/arturbosch/detekt/api/SeverityLevel;", "getInternalSeverity$detekt_api", "()Lio/gitlab/arturbosch/detekt/api/SeverityLevel;", "setInternalSeverity$detekt_api", "(Lio/gitlab/arturbosch/detekt/api/SeverityLevel;)V", "severity", "getSeverity", "id", "getId", "compact", "compactWithSignature", "toString", "messageOrDescription", "detekt-api"})
@SourceDebugExtension(value={"SMAP\nCodeSmell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeSmell.kt\nio/gitlab/arturbosch/detekt/api/CodeSmell\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public class CodeSmell
implements Finding {
    @NotNull
    private final Issue issue;
    @NotNull
    private final Entity entity;
    @NotNull
    private final String message;
    @NotNull
    private final List<Metric> metrics;
    @NotNull
    private final List<Entity> references;
    @NotNull
    private SeverityLevel internalSeverity;
    @NotNull
    private final String id;

    public CodeSmell(@NotNull Issue issue, @NotNull Entity entity, @NotNull String message, @NotNull List<Metric> metrics, @NotNull List<Entity> references) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter(references, (String)"references");
        this.issue = issue;
        this.entity = entity;
        this.message = message;
        this.metrics = metrics;
        this.references = references;
        this.internalSeverity = SeverityLevel.WARNING;
        this.id = this.issue.getId();
    }

    public /* synthetic */ CodeSmell(Issue issue, Entity entity, String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(issue, entity, string, list, list2);
    }

    @Override
    @NotNull
    public final Issue getIssue() {
        return this.issue;
    }

    @Override
    @NotNull
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    public List<Metric> getMetrics() {
        return this.metrics;
    }

    @Override
    @NotNull
    public List<Entity> getReferences() {
        return this.references;
    }

    @NotNull
    public final SeverityLevel getInternalSeverity$detekt_api() {
        return this.internalSeverity;
    }

    public final void setInternalSeverity$detekt_api(@NotNull SeverityLevel severityLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)severityLevel), (String)"<set-?>");
        this.internalSeverity = severityLevel;
    }

    @Override
    @NotNull
    public SeverityLevel getSeverity() {
        return this.internalSeverity;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String compact() {
        return this.getId() + " - " + this.getEntity().compact();
    }

    @Override
    @NotNull
    public String compactWithSignature() {
        return this.compact() + " - Signature=" + this.getEntity().getSignature();
    }

    @NotNull
    public String toString() {
        return "CodeSmell(issue=" + this.issue + ", entity=" + this.getEntity() + ", message=" + this.getMessage() + ", metrics=" + this.getMetrics() + ", references=" + this.getReferences() + ", severity=" + (Object)((Object)this.getSeverity()) + ", id='" + this.getId() + "')";
    }

    @Override
    @NotNull
    public String messageOrDescription() {
        CharSequence charSequence;
        CharSequence charSequence2 = this.getMessage();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = this.issue.getDescription();
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @Override
    @NotNull
    public Location getLocation() {
        return Finding.DefaultImpls.getLocation(this);
    }

    @Override
    @NotNull
    public SourceLocation getStartPosition() {
        return Finding.DefaultImpls.getStartPosition(this);
    }

    @Override
    @NotNull
    public TextLocation getCharPosition() {
        return Finding.DefaultImpls.getCharPosition(this);
    }

    @Override
    @NotNull
    public String getFile() {
        return Finding.DefaultImpls.getFile(this);
    }

    @Override
    @NotNull
    public String getSignature() {
        return Finding.DefaultImpls.getSignature(this);
    }

    @Override
    @Nullable
    public Metric metricByType(@NotNull String type) {
        return Finding.DefaultImpls.metricByType(this, type);
    }
}

