/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/api/Debt;", "", "days", "", "hours", "mins", "<init>", "(III)V", "getDays", "()I", "getHours", "getMins", "plus", "other", "toString", "", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "Companion", "detekt-api"})
public final class Debt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int days;
    private final int hours;
    private final int mins;
    @NotNull
    private static final Debt TWENTY_MINS = new Debt(0, 0, 20);
    @NotNull
    private static final Debt TEN_MINS = new Debt(0, 0, 10);
    @NotNull
    private static final Debt FIVE_MINS = new Debt(0, 0, 5);
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;

    public Debt(int days, int hours, int mins) {
        this.days = days;
        this.hours = hours;
        this.mins = mins;
        if (!(this.days >= 0 && this.hours >= 0 && this.mins >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.days != 0 || this.hours != 0 || this.mins != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Debt(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(n, n2, n3);
    }

    public final int getDays() {
        return this.days;
    }

    public final int getHours() {
        return this.hours;
    }

    public final int getMins() {
        return this.mins;
    }

    @NotNull
    public final Debt plus(@NotNull Debt other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int minutes = this.mins + other.mins;
        int hours = this.hours + other.hours;
        int days = this.days + other.days;
        hours += minutes / 60;
        days += hours / 24;
        return new Debt(days, hours %= 24, minutes %= 60);
    }

    @NotNull
    public String toString() {
        StringBuilder $this$toString_u24lambda_u240 = new StringBuilder();
        boolean bl = false;
        if (this.days > 0) {
            $this$toString_u24lambda_u240.append(this.days + "d ");
        }
        if (this.hours > 0) {
            $this$toString_u24lambda_u240.append(this.hours + "h ");
        }
        if (this.mins > 0) {
            $this$toString_u24lambda_u240.append(this.mins + "min");
        }
        String string = $this$toString_u24lambda_u240.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
        return ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
    }

    public final int component1() {
        return this.days;
    }

    public final int component2() {
        return this.hours;
    }

    public final int component3() {
        return this.mins;
    }

    @NotNull
    public final Debt copy(int days, int hours, int mins) {
        return new Debt(days, hours, mins);
    }

    public static /* synthetic */ Debt copy$default(Debt debt, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = debt.days;
        }
        if ((n4 & 2) != 0) {
            n2 = debt.hours;
        }
        if ((n4 & 4) != 0) {
            n3 = debt.mins;
        }
        return debt.copy(n, n2, n3);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.days);
        result = result * 31 + Integer.hashCode(this.hours);
        result = result * 31 + Integer.hashCode(this.mins);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Debt)) {
            return false;
        }
        Debt debt = (Debt)other;
        if (this.days != debt.days) {
            return false;
        }
        if (this.hours != debt.hours) {
            return false;
        }
        return this.mins == debt.mins;
    }

    public Debt() {
        this(0, 0, 0, 7, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/api/Debt$Companion;", "", "<init>", "()V", "TWENTY_MINS", "Lio/gitlab/arturbosch/detekt/api/Debt;", "getTWENTY_MINS", "()Lio/gitlab/arturbosch/detekt/api/Debt;", "TEN_MINS", "getTEN_MINS", "FIVE_MINS", "getFIVE_MINS", "HOURS_PER_DAY", "", "MINUTES_PER_HOUR", "detekt-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Debt getTWENTY_MINS() {
            return TWENTY_MINS;
        }

        @NotNull
        public final Debt getTEN_MINS() {
            return TEN_MINS;
        }

        @NotNull
        public final Debt getFIVE_MINS() {
            return FIVE_MINS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

