/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Extension;
import io.gitlab.arturbosch.detekt.api.SetupContext;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/api/OutputReport;", "Lio/gitlab/arturbosch/detekt/api/Extension;", "<init>", "()V", "ending", "", "getEnding", "()Ljava/lang/String;", "name", "getName", "write", "", "filePath", "Ljava/nio/file/Path;", "detektion", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "render", "detekt-api"})
public abstract class OutputReport
implements Extension {
    @NotNull
    public abstract String getEnding();

    @Nullable
    public String getName() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
    }

    public final void write(@NotNull Path filePath, @NotNull Detektion detektion) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)detektion, (String)"detektion");
        String reportData = this.render(detektion);
        if (reportData != null) {
            Path path;
            boolean bl = Intrinsics.areEqual((Object)PathsKt.getExtension((Path)filePath), (Object)this.getEnding());
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "The " + this.getName() + " needs to have a file ending of type ." + this.getEnding() + ", but was " + filePath.getFileName() + '.';
                throw new AssertionError((Object)string);
            }
            Path path2 = filePath.getParent();
            if (path2 != null) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                path = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
            } else {
                path = null;
            }
            PathsKt.writeText$default((Path)filePath, (CharSequence)reportData, null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
    }

    @Nullable
    public abstract String render(@NotNull Detektion var1);

    @Override
    @NotNull
    public String getId() {
        return Extension.DefaultImpls.getId(this);
    }

    @Override
    public int getPriority() {
        return Extension.DefaultImpls.getPriority(this);
    }

    @Override
    public void init(@NotNull Config config) {
        Extension.DefaultImpls.init((Extension)this, config);
    }

    @Override
    public void init(@NotNull SetupContext context) {
        Extension.DefaultImpls.init((Extension)this, context);
    }
}

