/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api.internal;

import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"pathMatcher", "Ljava/nio/file/PathMatcher;", "pattern", "", "USE_GLOB_MSG", "detekt-api"})
public final class PathMatchersKt {
    @NotNull
    private static final String USE_GLOB_MSG = "Only globbing patterns are supported as they are treated os-independently by the PathMatcher api.";

    @NotNull
    public static final PathMatcher pathMatcher(@NotNull String pattern) {
        String string;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string2 = StringsKt.substringBefore$default((String)pattern, (String)":", null, (int)2, null);
        if (Intrinsics.areEqual((Object)string2, (Object)"glob")) {
            string = pattern;
        } else {
            if (Intrinsics.areEqual((Object)string2, (Object)"regex")) {
                throw new IllegalArgumentException(USE_GLOB_MSG);
            }
            string = "glob:" + pattern;
        }
        String result = string;
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(result);
        Intrinsics.checkNotNullExpressionValue((Object)pathMatcher, (String)"getPathMatcher(...)");
        return pathMatcher;
    }
}

