/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/cli/ExistingPathConverter;", "Lcom/beust/jcommander/IStringConverter;", "Ljava/nio/file/Path;", "<init>", "()V", "convert", "value", "", "detekt-cli"})
@SourceDebugExtension(value={"SMAP\nArgumentConverters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentConverters.kt\nio/gitlab/arturbosch/detekt/cli/ExistingPathConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class ExistingPathConverter
implements IStringConverter<Path> {
    @NotNull
    public Path convert(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(!StringsKt.isBlank((CharSequence)value))) {
            boolean bl = false;
            String string = "Provided path '" + value + "' is empty.";
            throw new IllegalArgumentException(string.toString());
        }
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path config = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(config, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new ParameterException("Provided path '" + value + "' does not exist!");
        }
        return config;
    }
}

