/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli.runners;

import io.github.detekt.tooling.api.DefaultConfigurationProvider;
import io.github.detekt.tooling.api.spec.ExtensionsSpec;
import io.github.detekt.tooling.api.spec.ProcessingSpec;
import io.github.detekt.tooling.dsl.ExtensionsSpecBuilder;
import io.github.detekt.tooling.dsl.ProcessingSpecBuilder;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.MultipleExistingPathConverter;
import io.gitlab.arturbosch.detekt.cli.runners.Executable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0006j\u0002`\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00060\u0006j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/cli/runners/ConfigExporter;", "Lio/gitlab/arturbosch/detekt/cli/runners/Executable;", "arguments", "Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "outputPrinter", "Lkotlin/text/Appendable;", "Ljava/lang/Appendable;", "<init>", "(Lio/gitlab/arturbosch/detekt/cli/CliArgs;Ljava/lang/Appendable;)V", "Ljava/lang/Appendable;", "execute", "", "detekt-cli"})
@SourceDebugExtension(value={"SMAP\nConfigExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigExporter.kt\nio/gitlab/arturbosch/detekt/cli/runners/ConfigExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n1#2:28\n*E\n"})
public final class ConfigExporter
implements Executable {
    @NotNull
    private final CliArgs arguments;
    @NotNull
    private final Appendable outputPrinter;

    public ConfigExporter(@NotNull CliArgs arguments, @NotNull Appendable outputPrinter) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)outputPrinter, (String)"outputPrinter");
        this.arguments = arguments;
        this.outputPrinter = outputPrinter;
    }

    @Override
    public void execute() {
        String string = this.arguments.getConfig();
        if (string == null) {
            string = "detekt.yml";
        }
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path configPath = path;
        ProcessingSpec spec = ProcessingSpec.Companion.invoke(arg_0 -> ConfigExporter.execute$lambda$3(this, arg_0));
        DefaultConfigurationProvider.Companion.load$default((DefaultConfigurationProvider.Companion)DefaultConfigurationProvider.Companion, (ExtensionsSpec)spec.getExtensionsSpec(), null, (int)2, null).copy(configPath);
        StringBuilder stringBuilder = new StringBuilder().append("Successfully copied default config to ");
        Path path2 = configPath.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        Appendable appendable = this.outputPrinter.append(stringBuilder.append(path2).toString());
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
    }

    private static final Collection execute$lambda$3$lambda$2$lambda$1(ConfigExporter this$0) {
        List list;
        Object object;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = this$0.arguments.getPlugins();
        if (string != null) {
            String it = string;
            boolean bl = false;
            object = new MultipleExistingPathConverter().convert(it);
        } else {
            object = list = null;
        }
        if (object == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Unit execute$lambda$3$lambda$2(ConfigExporter this$0, ExtensionsSpecBuilder $this$extensions) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$extensions, (String)"$this$extensions");
        $this$extensions.setDisableDefaultRuleSets(this$0.arguments.getDisableDefaultRuleSets());
        $this$extensions.fromPaths(() -> ConfigExporter.execute$lambda$3$lambda$2$lambda$1(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$3(ConfigExporter this$0, ProcessingSpecBuilder $this$ProcessingSpec) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$ProcessingSpec, (String)"$this$ProcessingSpec");
        $this$ProcessingSpec.extensions(arg_0 -> ConfigExporter.execute$lambda$3$lambda$2(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

