/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules;

import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0005"}, d2={"lastArgumentMatchesUrl", "", "", "lastArgumentMatchesMarkdownUrlSyntax", "lastArgumentMatchesKotlinReferenceUrlSyntax", "detekt-psi-utils"})
public final class StringExtensionsKt {
    public static final boolean lastArgumentMatchesUrl(@NotNull String $this$lastArgumentMatchesUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$lastArgumentMatchesUrl, (String)"<this>");
        CharSequence charSequence = ((Object)StringsKt.trimEnd((CharSequence)$this$lastArgumentMatchesUrl)).toString();
        Object object = new Regex("\\s+");
        int n = 0;
        String lastArgument = (String)CollectionsKt.last((List)object.split(charSequence, n));
        charSequence = $this$lastArgumentMatchesUrl;
        try {
            CharSequence $this$lastArgumentMatchesUrl_u24lambda_u240 = charSequence;
            boolean bl = false;
            object = Result.constructor-impl((Object)new URL(lastArgument).toURI());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return Result.isSuccess-impl((Object)object);
    }

    public static final boolean lastArgumentMatchesMarkdownUrlSyntax(@NotNull String $this$lastArgumentMatchesMarkdownUrlSyntax) {
        Intrinsics.checkNotNullParameter((Object)$this$lastArgumentMatchesMarkdownUrlSyntax, (String)"<this>");
        String urlNonCapturingRegex = "(?:(?!\\s).)+";
        String markdownUrlTitleRegexStrWithBraces = "\\([^\\(\\\\\\n]*(?:\\\\.[^\\)\\\\\\n]*)*\\)";
        String markdownUrlTitleRegexStrWithSingleOrDoubleQuotes = "([\"'])(?:(?!(?:\\1|\\\\)).)*(?:\\\\.(?:(?!(?:\\1|\\\\)).)*)*\\1";
        String markdownUrlTitleRegex = "(?:" + markdownUrlTitleRegexStrWithSingleOrDoubleQuotes + '|' + markdownUrlTitleRegexStrWithBraces + ')';
        Regex regex = new Regex("\\[.+\\]\\(" + urlNonCapturingRegex + "(?:\\s+" + markdownUrlTitleRegex + ")?\\s*\\)$");
        CharSequence charSequence = ((Object)StringsKt.trimEnd((CharSequence)$this$lastArgumentMatchesMarkdownUrlSyntax)).toString();
        return regex.containsMatchIn(charSequence);
    }

    public static final boolean lastArgumentMatchesKotlinReferenceUrlSyntax(@NotNull String $this$lastArgumentMatchesKotlinReferenceUrlSyntax) {
        Intrinsics.checkNotNullParameter((Object)$this$lastArgumentMatchesKotlinReferenceUrlSyntax, (String)"<this>");
        Regex regex = new Regex("\\[[\\w|\\.]*\\]$");
        CharSequence charSequence = ((Object)StringsKt.trimEnd((CharSequence)$this$lastArgumentMatchesKotlinReferenceUrlSyntax)).toString();
        return regex.containsMatchIn(charSequence);
    }
}

