/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.coroutines;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessorsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u000f*\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/coroutines/RedundantSuspendModifier;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isValidCandidateExpression", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "hasSuspendCalls", "detekt-rules-coroutines"})
@SourceDebugExtension(value={"SMAP\nRedundantSuspendModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantSuspendModifier.kt\nio/gitlab/arturbosch/detekt/rules/coroutines/RedundantSuspendModifier\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n266#2:135\n277#2,10:136\n299#2:146\n1755#3,3:147\n1755#3,3:150\n*S KotlinDebug\n*F\n+ 1 RedundantSuspendModifier.kt\nio/gitlab/arturbosch/detekt/rules/coroutines/RedundantSuspendModifier\n*L\n76#1:135\n76#1:136,10\n76#1:146\n103#1:147,3\n112#1:150,3\n*E\n"})
public final class RedundantSuspendModifier
extends Rule {
    @NotNull
    private final Issue issue;

    public RedundantSuspendModifier(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("RedundantSuspendModifier", Severity.Minor, "The `suspend` modifier is only needed for functions that contain suspending calls.", Debt.Companion.getFIVE_MINS());
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        void $this$anyDescendantOfType$iv;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        KtModifierList ktModifierList = function.getModifierList();
        if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD)) == null) {
            return;
        }
        KtModifierList suspendModifier = ktModifierList;
        if (!function.hasBody()) {
            return;
        }
        if (function.hasModifier(KtTokens.OVERRIDE_KEYWORD) || function.hasModifier(KtTokens.ACTUAL_KEYWORD)) {
            return;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.FUNCTION, (Object)function);
        if (simpleFunctionDescriptor == null) {
            return;
        }
        SimpleFunctionDescriptor descriptor = simpleFunctionDescriptor;
        if (descriptor.getModality() == Modality.OPEN) {
            return;
        }
        PsiElement psiElement = (PsiElement)function;
        Function1 predicate$iv = arg_0 -> RedundantSuspendModifier.visitNamedFunction$lambda$0(this, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        if (!((PsiElement)result$iv$iv$iv.element != null)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)suspendModifier, (int)0, (int)2, null), "Function has redundant `suspend` modifier.", null, null, 24, null));
        }
    }

    private final boolean isValidCandidateExpression(KtExpression $this$isValidCandidateExpression) {
        PsiElement parent;
        KtExpression ktExpression = $this$isValidCandidateExpression;
        return ktExpression instanceof KtOperationReferenceExpression || ktExpression instanceof KtForExpression || ktExpression instanceof KtProperty || ktExpression instanceof KtNameReferenceExpression ? true : ((parent = $this$isValidCandidateExpression.getParent()) instanceof KtCallExpression && Intrinsics.areEqual((Object)((KtCallExpression)parent).getCalleeExpression(), (Object)$this$isValidCandidateExpression) ? true : $this$isValidCandidateExpression instanceof KtCallExpression && ((KtCallExpression)$this$isValidCandidateExpression).getCalleeExpression() instanceof KtCallExpression);
    }

    private final boolean hasSuspendCalls(KtExpression $this$hasSuspendCalls) {
        boolean bl;
        block16: {
            if (!this.isValidCandidateExpression($this$hasSuspendCalls)) {
                return false;
            }
            KtExpression ktExpression = $this$hasSuspendCalls;
            if (ktExpression instanceof KtForExpression) {
                ResolvedCall iteratorResolvedCall = (ResolvedCall)this.getBindingContext().get((ReadOnlySlice)BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, (Object)((KtForExpression)$this$hasSuspendCalls).getLoopRange());
                ResolvedCall loopRangeHasNextResolvedCall = (ResolvedCall)this.getBindingContext().get((ReadOnlySlice)BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, (Object)((KtForExpression)$this$hasSuspendCalls).getLoopRange());
                ResolvedCall loopRangeNextResolvedCall = (ResolvedCall)this.getBindingContext().get((ReadOnlySlice)BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, (Object)((KtForExpression)$this$hasSuspendCalls).getLoopRange());
                Object[] objectArray = new ResolvedCall[]{iteratorResolvedCall, loopRangeHasNextResolvedCall, loopRangeNextResolvedCall};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ResolvedCall it = (ResolvedCall)element$iv;
                        boolean bl2 = false;
                        ResolvedCall resolvedCall = it;
                        boolean bl3 = resolvedCall != null && (resolvedCall = (FunctionDescriptor)resolvedCall.getResultingDescriptor()) != null ? resolvedCall.isSuspend() : false;
                        if (!bl3) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            } else if (ktExpression instanceof KtProperty) {
                if (((KtProperty)$this$hasSuspendCalls).hasDelegateExpression()) {
                    VariableDescriptorWithAccessors variableDescriptor;
                    Object loopRangeHasNextResolvedCall = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)$this$hasSuspendCalls);
                    VariableDescriptorWithAccessors variableDescriptorWithAccessors = variableDescriptor = loopRangeHasNextResolvedCall instanceof VariableDescriptorWithAccessors ? (VariableDescriptorWithAccessors)loopRangeHasNextResolvedCall : null;
                    List list = variableDescriptorWithAccessors != null ? VariableDescriptorWithAccessorsKt.getAccessors((VariableDescriptorWithAccessors)variableDescriptorWithAccessors) : null;
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    List accessors = list;
                    Iterable $this$any$iv = accessors;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FunctionDescriptor delegatedFunctionDescriptor;
                            VariableAccessorDescriptor accessor = (VariableAccessorDescriptor)element$iv;
                            boolean bl4 = false;
                            ResolvedCall resolvedCall = (ResolvedCall)this.getBindingContext().get((ReadOnlySlice)BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, (Object)accessor);
                            FunctionDescriptor functionDescriptor = delegatedFunctionDescriptor = resolvedCall != null ? (FunctionDescriptor)resolvedCall.getResultingDescriptor() : null;
                            boolean bl5 = functionDescriptor != null ? functionDescriptor.isSuspend() : false;
                            if (!bl5) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            } else {
                ResolvedCall resolvedCall;
                ResolvedCall resolvedCall2 = resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$hasSuspendCalls), (BindingContext)this.getBindingContext());
                Object $this$any$iv = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                FunctionDescriptor functionDescriptor = $this$any$iv instanceof FunctionDescriptor ? (FunctionDescriptor)$this$any$iv : null;
                boolean bl6 = functionDescriptor != null ? functionDescriptor.isSuspend() : false;
                if (bl6) {
                    bl = true;
                } else {
                    String s;
                    ResolvedCall resolvedCall3 = resolvedCall;
                    $this$any$iv = resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null;
                    PropertyDescriptor propertyDescriptor = $this$any$iv instanceof PropertyDescriptor ? (PropertyDescriptor)$this$any$iv : null;
                    PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
                    String string = s = propertyDescriptor2 != null && (propertyDescriptor2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)propertyDescriptor2))) != null ? propertyDescriptor2.asString() : null;
                    bl = (string != null ? StringsKt.startsWith$default((String)string, (String)"kotlin.coroutines.", (boolean)false, (int)2, null) : false) && StringsKt.endsWith$default((String)s, (String)".coroutineContext", (boolean)false, (int)2, null);
                }
            }
        }
        return bl;
    }

    private static final boolean visitNamedFunction$lambda$0(RedundantSuspendModifier this$0, KtExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.hasSuspendCalls(it);
    }
}

