/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.coroutines;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0015H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0018H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0019H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0011H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lio/gitlab/arturbosch/detekt/rules/coroutines/SleepInsteadOfDelay;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "checkAndReport", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isThreadSleepFunction", "", "getNearestParentForSuspension", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "psiElement", "isSuspendAllowed", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "shouldReport", "Companion", "detekt-rules-coroutines"})
@SourceDebugExtension(value={"SMAP\nSleepInsteadOfDelay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SleepInsteadOfDelay.kt\nio/gitlab/arturbosch/detekt/rules/coroutines/SleepInsteadOfDelay\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,184:1\n138#2:185\n*S KotlinDebug\n*F\n+ 1 SleepInsteadOfDelay.kt\nio/gitlab/arturbosch/detekt/rules/coroutines/SleepInsteadOfDelay\n*L\n123#1:185\n*E\n"})
public final class SleepInsteadOfDelay
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final String SUSPEND_FUN_MESSAGE = "This use of Thread.sleep() inside a suspend function should be replaced by delay().";
    @NotNull
    private static final String FQ_NAME = "java.lang.Thread.sleep";

    public SleepInsteadOfDelay(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "Usage of `Thread.sleep()` in coroutines can potentially halt multiple coroutines at once.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ SleepInsteadOfDelay(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        this.checkAndReport((KtExpression)expression);
    }

    public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallableReferenceExpression(expression);
        this.checkAndReport((KtExpression)expression);
    }

    private final void checkAndReport(KtExpression expression) {
        if (this.isThreadSleepFunction(expression) && this.shouldReport(expression)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), SUSPEND_FUN_MESSAGE, null, null, 24, null));
        }
    }

    private final boolean isThreadSleepFunction(KtExpression $this$isThreadSleepFunction) {
        FqName fqName;
        CallableDescriptor callableDescriptor;
        ResolvedCall resolvedCall;
        return $this$isThreadSleepFunction instanceof KtCallableReferenceExpression ? SleepInsteadOfDelay.isThreadSleepFunction$isSleepCallableRef((KtCallableReferenceExpression)$this$isThreadSleepFunction, this) : Intrinsics.areEqual((resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$isThreadSleepFunction), (BindingContext)this.getBindingContext())) != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null && (fqName = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor))) != null ? fqName.asString() : null, (Object)FQ_NAME);
    }

    private final PsiElement getNearestParentForSuspension(PsiElement psiElement) {
        Class[] classArray = new Class[]{KtNamedFunction.class, KtValueArgument.class, KtLambdaExpression.class};
        return PsiUtilsKt.getParentOfTypesAndPredicate((PsiElement)psiElement, (boolean)false, (Class[])classArray, arg_0 -> SleepInsteadOfDelay.getNearestParentForSuspension$lambda$0(this, arg_0));
    }

    private final boolean isSuspendAllowed(PsiElement $this$isSuspendAllowed) {
        PsiElement psiElement = $this$isSuspendAllowed;
        return psiElement instanceof KtValueArgument ? this.isSuspendAllowed((KtValueArgument)$this$isSuspendAllowed) : (psiElement instanceof KtNamedFunction ? this.isSuspendAllowed((KtNamedFunction)$this$isSuspendAllowed) : (psiElement instanceof KtLambdaExpression ? this.isSuspendAllowed((KtLambdaExpression)$this$isSuspendAllowed) : false));
    }

    private final boolean isSuspendAllowed(KtValueArgument $this$isSuspendAllowed) {
        Class[] classArray = new Class[]{KtCallExpression.class};
        KtCallExpression ktCallExpression = (KtCallExpression)PsiUtilsKt.getParentOfTypes((PsiElement)((PsiElement)$this$isSuspendAllowed), (boolean)true, (Class[])classArray);
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression parent = ktCallExpression;
        classArray = CallUtilKt.getResolvedCall((KtElement)((KtElement)parent), (BindingContext)this.getBindingContext());
        ValueParameterDescriptor valueParameterDescriptor = classArray != null ? CallUtilKt.getParameterForArgument((ResolvedCall)classArray, (ValueArgument)((ValueArgument)$this$isSuspendAllowed)) : null;
        ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
        return valueParameterDescriptor2 != null && (valueParameterDescriptor2 = valueParameterDescriptor2.getReturnType()) != null ? FunctionTypesKt.isSuspendFunctionType((KotlinType)valueParameterDescriptor2) : false;
    }

    private final boolean isSuspendAllowed(KtLambdaExpression $this$isSuspendAllowed) {
        Class[] classArray = new Class[]{KtProperty.class};
        KtProperty ktProperty = (KtProperty)PsiUtilsKt.getParentOfTypes((PsiElement)((PsiElement)$this$isSuspendAllowed), (boolean)true, (Class[])classArray);
        if (ktProperty == null) {
            return false;
        }
        KtProperty parent = ktProperty;
        VariableDescriptor variableDescriptor = (VariableDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.VARIABLE, (Object)parent);
        if (variableDescriptor == null) {
            return false;
        }
        VariableDescriptor properDescriptor = variableDescriptor;
        KotlinType kotlinType = properDescriptor.getReturnType();
        return kotlinType != null ? FunctionTypesKt.isSuspendFunctionType((KotlinType)kotlinType) : false;
    }

    private final boolean isSuspendAllowed(KtNamedFunction $this$isSuspendAllowed) {
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.FUNCTION, (Object)$this$isSuspendAllowed);
        if (simpleFunctionDescriptor == null) {
            return false;
        }
        SimpleFunctionDescriptor functionDescriptor = simpleFunctionDescriptor;
        return functionDescriptor.isSuspend();
    }

    private final boolean shouldReport(KtExpression expression) {
        PsiElement psiElement = this.getNearestParentForSuspension((PsiElement)expression);
        if (psiElement == null) {
            return false;
        }
        PsiElement nearestParentForSuspension = psiElement;
        return this.isSuspendAllowed(nearestParentForSuspension);
    }

    private static final boolean isThreadSleepFunction$isSleepCallableRef(KtCallableReferenceExpression $this$isThreadSleepFunction_u24isSleepCallableRef, SleepInsteadOfDelay this$0) {
        boolean bl;
        if ($this$isThreadSleepFunction_u24isSleepCallableRef.getParent() instanceof KtValueArgument) {
            KtSimpleNameExpression ktSimpleNameExpression = $this$isThreadSleepFunction_u24isSleepCallableRef.getCallableReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
            bl = this$0.isThreadSleepFunction((KtExpression)ktSimpleNameExpression);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean getNearestParentForSuspension$isNearestParentForSuspension(KtValueArgument $this$getNearestParentForSuspension_u24isNearestParentForSuspension, SleepInsteadOfDelay this$0) {
        ValueParameterDescriptor valueParameterDescriptor;
        Class[] classArray = new Class[]{KtCallExpression.class};
        KtCallExpression ktCallExpression = (KtCallExpression)PsiUtilsKt.getParentOfTypes((PsiElement)((PsiElement)$this$getNearestParentForSuspension_u24isNearestParentForSuspension), (boolean)true, (Class[])classArray);
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression parent = ktCallExpression;
        ResolvedCall callDescriptor = CallUtilKt.getResolvedCall((KtElement)((KtElement)parent), (BindingContext)this$0.getBindingContext());
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)parent), (BindingContext)this$0.getBindingContext());
        if (resolvedCall == null || (valueParameterDescriptor = CallUtilKt.getParameterForArgument((ResolvedCall)resolvedCall, (ValueArgument)((ValueArgument)$this$getNearestParentForSuspension_u24isNearestParentForSuspension))) == null) {
            return false;
        }
        ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
        ResolvedCall resolvedCall2 = callDescriptor;
        CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
        FunctionDescriptor functionDescriptor = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        return !functionDescriptor2.isInline() || valueParameterDescriptor2.isNoinline() || valueParameterDescriptor2.isCrossinline();
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean getNearestParentForSuspension$lambda$0(SleepInsteadOfDelay this$0, Object it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it;
        if (object instanceof KtValueArgument) {
            bl = SleepInsteadOfDelay.getNearestParentForSuspension$isNearestParentForSuspension((KtValueArgument)it, this$0);
        } else if (object instanceof KtNamedFunction) {
            bl = true;
        } else if (object instanceof KtLambdaExpression) {
            void strict$iv;
            void $this$getParentOfType$iv;
            PsiElement psiElement = (PsiElement)it;
            boolean bl2 = true;
            Class[] classArray = new Class[]{KtValueArgument.class};
            Class[] stopAt$iv = classArray;
            boolean $i$f$getParentOfType = false;
            bl = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtProperty.class, (boolean)strict$iv, (Class[])Arrays.copyOf(stopAt$iv, stopAt$iv.length)) != null;
        } else {
            bl = false;
        }
        return bl;
    }

    public SleepInsteadOfDelay() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/coroutines/SleepInsteadOfDelay$Companion;", "", "<init>", "()V", "SUSPEND_FUN_MESSAGE", "", "FQ_NAME", "detekt-rules-coroutines"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

