/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.coroutines;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/coroutines/SuspendFunWithFlowReturnType;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isCoroutinesFlow", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "detekt-rules-coroutines"})
@SourceDebugExtension(value={"SMAP\nSuspendFunWithFlowReturnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspendFunWithFlowReturnType.kt\nio/gitlab/arturbosch/detekt/rules/coroutines/SuspendFunWithFlowReturnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class SuspendFunWithFlowReturnType
extends Rule {
    @NotNull
    private final Issue issue;

    public SuspendFunWithFlowReturnType(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("SuspendFunWithFlowReturnType", Severity.Minor, "The `suspend` modifier should not be used for functions that return a Coroutines Flow type. Flows are cold streams and invoking a function that returns one should not produce any side effects.", Debt.Companion.getTEN_MINS());
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        block2: {
            KotlinType kotlinType;
            KotlinType kotlinType2;
            KotlinType kotlinType3;
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            KtModifierList ktModifierList = function.getModifierList();
            if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD)) == null) {
                return;
            }
            KtModifierList suspendModifier = ktModifierList;
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.FUNCTION, (Object)function);
            if (simpleFunctionDescriptor == null || (kotlinType3 = simpleFunctionDescriptor.getReturnType()) == null) break block2;
            KotlinType it = kotlinType2 = kotlinType3;
            boolean bl = false;
            Object object = kotlinType = this.isCoroutinesFlow(it) ? kotlinType2 : null;
            if (kotlinType != null) {
                it = kotlinType2 = kotlinType;
                boolean bl2 = false;
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)suspendModifier, (int)0, (int)2, null), "`suspend` function returns Coroutines Flow.", null, null, 24, null));
            }
        }
    }

    private final boolean isCoroutinesFlow(KotlinType $this$isCoroutinesFlow) {
        return SequencesKt.contains((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super KotlinType>, Continuation<? super Unit>, Object>($this$isCoroutinesFlow, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ KotlinType $this_isCoroutinesFlow;
            {
                this.$this_isCoroutinesFlow = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yield((Object)this.$this_isCoroutinesFlow, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = $this$sequence.yieldAll((Iterable)org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.supertypes((KotlinType)this.$this_isCoroutinesFlow), (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super KotlinType>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(SequenceScope<? super KotlinType> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), SuspendFunWithFlowReturnType::isCoroutinesFlow$lambda$2), (Object)"kotlinx.coroutines.flow.Flow");
    }

    private static final String isCoroutinesFlow$lambda$2(KotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FqName fqName = TypeUtilsKt.fqNameOrNull((KotlinType)it);
        return fqName != null ? fqName.asString() : null;
    }
}

