/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.performance;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0013H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/ForEachOnRange;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "rangeOperators", "", "", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isRangeOperatorsChainCall", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "isRangeOperator", "detekt-rules-performance"})
public final class ForEachOnRange
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final Set<String> rangeOperators;

    public ForEachOnRange(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ForEachOnRange", Severity.Performance, "Using the forEach method on ranges has a heavy performance cost. Prefer using simple for loops.", Debt.Companion.getFIVE_MINS());
        Object[] objectArray = new String[]{"..", "rangeTo", "downTo", "until", "..<"};
        this.rangeOperators = SetsKt.setOf((Object[])objectArray);
    }

    public /* synthetic */ ForEachOnRange(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        block2: {
            KtElement forExpression;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitCallExpression(expression);
            KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)expression));
            if (ktSimpleNameExpression == null) break block2;
            KtSimpleNameExpression it = ktSimpleNameExpression;
            boolean bl = false;
            if (!it.textMatches((CharSequence)"forEach")) {
                return;
            }
            KtExpression ktExpression = KtPsiUtilKt.getReceiverExpression((KtSimpleNameExpression)it);
            Object object = forExpression = ktExpression != null ? KotlinUtilsKt.deparenthesize((KtElement)((KtElement)ktExpression)) : null;
            if (forExpression != null && this.isRangeOperatorsChainCall(forExpression)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)forExpression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
    }

    private final boolean isRangeOperatorsChainCall(KtElement expression) {
        boolean bl;
        if (this.isRangeOperator(expression)) {
            bl = true;
        } else {
            KtElement ktElement = expression;
            if (ktElement instanceof KtBinaryExpression) {
                KtExpression ktExpression = ((KtBinaryExpression)expression).getLeft();
                if (ktExpression == null || (ktExpression = KotlinUtilsKt.deparenthesize((KtElement)((KtElement)ktExpression))) == null) {
                    return false;
                }
                KtExpression receiverExpression = ktExpression;
                bl = this.isRangeOperatorsChainCall((KtElement)receiverExpression);
            } else if (ktElement instanceof KtDotQualifiedExpression) {
                KtElement receiverExpression = KotlinUtilsKt.deparenthesize((KtElement)((KtElement)((KtDotQualifiedExpression)expression).getReceiverExpression()));
                bl = this.isRangeOperatorsChainCall(receiverExpression);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isRangeOperator(KtElement expression) {
        KtExpression ktExpression;
        KtCallExpression ktCallExpression;
        KtElement ktElement = expression;
        String string = ktElement instanceof KtBinaryExpression ? ((KtBinaryExpression)expression).getOperationReference().getText() : (ktElement instanceof KtDotQualifiedExpression ? ((ktCallExpression = (ktExpression = ((KtDotQualifiedExpression)expression).getSelectorExpression()) instanceof KtCallExpression ? (KtCallExpression)ktExpression : null) != null && (ktCallExpression = ktCallExpression.getCalleeExpression()) != null ? ktCallExpression.getText() : null) : null);
        String operator = string;
        return CollectionsKt.contains((Iterable)this.rangeOperators, (Object)operator);
    }

    public ForEachOnRange() {
        this(null, 1, null);
    }
}

