/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.performance;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\rH\u0002J\f\u0010\u0014\u001a\u00020\u000f*\u00020\u0011H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/SpreadOperator;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitValueArgumentList", "", "list", "Lorg/jetbrains/kotlin/psi/KtValueArgumentList;", "isSimplePassThroughVararg", "", "arg", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "checkCanSkipArrayCopy", "argsList", "canSkipArrayCopyForSpreadArgument", "detekt-rules-performance"})
@SourceDebugExtension(value={"SMAP\nSpreadOperator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpreadOperator.kt\nio/gitlab/arturbosch/detekt/rules/performance/SpreadOperator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,121:1\n774#2:122\n865#2,2:123\n1863#2,2:125\n1755#2,3:128\n142#3:127\n*S KotlinDebug\n*F\n+ 1 SpreadOperator.kt\nio/gitlab/arturbosch/detekt/rules/performance/SpreadOperator\n*L\n68#1:122\n68#1:123,2\n70#1:125,2\n82#1:128,3\n80#1:127\n*E\n"})
public final class SpreadOperator
extends Rule {
    @NotNull
    private final Issue issue;

    public SpreadOperator(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("SpreadOperator", Severity.Performance, "In most cases using a spread operator causes a full copy of the array to be created before calling a method. This may result in a performance penalty.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ SpreadOperator(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitValueArgumentList(@NotNull KtValueArgumentList list) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        super.visitValueArgumentList(list);
        List list2 = list.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getArguments(...)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtValueArgument it = (KtValueArgument)element$iv$iv;
            boolean bl = false;
            if (!it.isSpread()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtValueArgument it = (KtValueArgument)element$iv;
            boolean bl = false;
            this.checkCanSkipArrayCopy(it, list);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSimplePassThroughVararg(KtValueArgument arg) {
        boolean bl;
        List list;
        KtExpression ktExpression = arg.getArgumentExpression();
        String argumentName = ktExpression != null ? ktExpression.getText() : null;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)arg;
        boolean $i$f$getStrictParentOfType2 = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction != null && (list = ktNamedFunction.getValueParameters()) != null) {
            boolean bl2;
            block5: {
                void $this$any$iv;
                Iterable $i$f$getStrictParentOfType2 = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtParameter it = (KtParameter)element$iv;
                        boolean bl3 = false;
                        if (!(it.isVarArg() && Intrinsics.areEqual((Object)it.getName(), (Object)argumentName))) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void checkCanSkipArrayCopy(KtValueArgument arg, KtValueArgumentList argsList) {
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            if (this.isSimplePassThroughVararg(arg)) {
                return;
            }
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)argsList), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        } else {
            if (this.canSkipArrayCopyForSpreadArgument(arg)) {
                return;
            }
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)argsList), (int)0, (int)2, null), "Used in this way a spread operator causes a full copy of the array to be created before calling a method. This may result in a performance penalty.", null, null, 24, null));
        }
    }

    private final boolean canSkipArrayCopyForSpreadArgument(KtValueArgument $this$canSkipArrayCopyForSpreadArgument) {
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$canSkipArrayCopyForSpreadArgument.getArgumentExpression()), (BindingContext)this.getBindingContext());
        if (resolvedCall == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
        CallableDescriptor calleeDescriptor = callableDescriptor;
        if (calleeDescriptor instanceof ParameterDescriptor && ArgumentsUtilsKt.isVararg((ParameterDescriptor)((ParameterDescriptor)calleeDescriptor))) {
            return true;
        }
        return calleeDescriptor instanceof ConstructorDescriptor || CompileTimeConstantUtils.isArrayFunctionCall((ResolvedCall)resolvedCall2) || Intrinsics.areEqual((Object)DescriptorUtils.getFqName((DeclarationDescriptor)((DeclarationDescriptor)calleeDescriptor)).asString(), (Object)"kotlin.arrayOfNulls");
    }

    public SpreadOperator() {
        this(null, 1, null);
    }
}

