/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.performance;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/UnnecessaryPartOfBinaryExpression;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "expressions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "operator", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "Companion", "detekt-rules-performance"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryPartOfBinaryExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryPartOfBinaryExpression.kt\nio/gitlab/arturbosch/detekt/rules/performance/UnnecessaryPartOfBinaryExpression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1557#2:80\n1628#2,3:81\n*S KotlinDebug\n*F\n+ 1 UnnecessaryPartOfBinaryExpression.kt\nio/gitlab/arturbosch/detekt/rules/performance/UnnecessaryPartOfBinaryExpression\n*L\n55#1:80\n55#1:81,3\n*E\n"})
public final class UnnecessaryPartOfBinaryExpression
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final Regex whiteSpace = new Regex("\\s");

    public UnnecessaryPartOfBinaryExpression(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UnnecessaryPartOfBinaryExpression", Severity.Performance, "Detects duplicate condition into binary expression and recommends to remove unnecessary checks", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryPartOfBinaryExpression(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryExpression(expression);
        IElementType iElementType = expression.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        IElementType operator = iElementType;
        if (!Intrinsics.areEqual((Object)operator, (Object)KtTokens.OROR) && !Intrinsics.areEqual((Object)operator, (Object)KtTokens.ANDAND)) {
            return;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent).getOperationToken(), (Object)operator)) {
            return;
        }
        Iterable $this$map$iv = this.expressions(expression, operator);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtExpression ktExpression = (KtExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence charSequence = string;
            Regex regex = whiteSpace;
            String string2 = "";
            collection.add(regex.replace(charSequence, string2));
        }
        List expressions = (List)destination$iv$iv;
        if (expressions.size() != kotlin.collections.CollectionsKt.distinct((Iterable)expressions).size()) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final List<KtExpression> expressions(KtBinaryExpression $this$expressions, IElementType operator) {
        List expressions = new ArrayList();
        UnnecessaryPartOfBinaryExpression.expressions$collect(operator, expressions, (KtExpression)$this$expressions);
        return expressions;
    }

    private static final void expressions$collect(IElementType $operator, List<KtExpression> expressions, KtExpression expression) {
        if (expression instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)expression).getOperationToken(), (Object)$operator)) {
            UnnecessaryPartOfBinaryExpression.expressions$collect($operator, expressions, ((KtBinaryExpression)expression).getLeft());
            UnnecessaryPartOfBinaryExpression.expressions$collect($operator, expressions, ((KtBinaryExpression)expression).getRight());
        } else {
            CollectionsKt.addIfNotNull((Collection)expressions, (Object)expression);
        }
    }

    public UnnecessaryPartOfBinaryExpression() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/UnnecessaryPartOfBinaryExpression$Companion;", "", "<init>", "()V", "whiteSpace", "Lkotlin/text/Regex;", "detekt-rules-performance"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

