/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lio/papermc/paperweight/tasks/CollectATsFromPatches;", "Lio/papermc/paperweight/tasks/BaseTask;", "()V", "extraPatchDir", "Lorg/gradle/api/file/DirectoryProperty;", "getExtraPatchDir", "()Lorg/gradle/api/file/DirectoryProperty;", "header", "Lorg/gradle/api/provider/Property;", "", "getHeader", "()Lorg/gradle/api/provider/Property;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "patchDir", "getPatchDir", "init", "", "readAts", "", "patches", "", "Ljava/nio/file/Path;", "run", "Companion", "paperweight-lib"})
public abstract class CollectATsFromPatches
extends BaseTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PATCH_CONTENT_START = "diff --git a/";
    @NotNull
    private static final String CO_AUTHOR_LINE = "Co-authored-by: ";

    @Input
    @NotNull
    public abstract Property<String> getHeader();

    @InputDirectory
    @Optional
    @NotNull
    public abstract DirectoryProperty getPatchDir();

    @InputDirectory
    @Optional
    @NotNull
    public abstract DirectoryProperty getExtraPatchDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Override
    public void init() {
        this.getHeader().convention((Object)"== AT ==");
        this.getOutputFile().convention((Provider)UtilsKt.defaultOutput(this, "at"));
    }

    @TaskAction
    public final void run() {
        Directory it;
        FileKt.deleteForcefully(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputFile())));
        List patches = new ArrayList();
        Directory directory = (Directory)this.getPatchDir().getOrNull();
        if (directory != null) {
            it = directory;
            boolean bl = false;
            CollectionsKt.addAll((Collection)patches, (Iterable)PathsKt.listDirectoryEntries((Path)FileKt.getPath((FileSystemLocation)it), (String)"*.patch"));
        }
        Directory directory2 = (Directory)this.getExtraPatchDir().getOrNull();
        if (directory2 != null) {
            it = directory2;
            boolean bl = false;
            CollectionsKt.addAll((Collection)patches, (Iterable)PathsKt.listDirectoryEntries((Path)FileKt.getPath((FileSystemLocation)it), (String)"*.patch"));
        }
        Path path = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputFile()));
        Iterable iterable = this.readAts(patches);
        OpenOption[] openOptionArray = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)Files.write(path, (Iterable<? extends CharSequence>)iterable, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> readAts(Iterable<? extends Path> patches) {
        HashSet<String> result2 = new HashSet<String>();
        Object object = this.getHeader().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"header.get()");
        String start = (String)object;
        Iterator<? extends Path> iterator = patches.iterator();
        while (iterator.hasNext()) {
            Path patch;
            Path path = patch = iterator.next();
            Closeable closeable = Files.newBufferedReader(path, Charsets.UTF_8);
            Throwable throwable = null;
            try {
                String line;
                BufferedReader bufferedReader = (BufferedReader)closeable;
                Intrinsics.checkNotNull((Object)bufferedReader);
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)bufferedReader);
                boolean bl = false;
                boolean reading = false;
                Iterator iterator2 = it.iterator();
                while (iterator2.hasNext() && !StringsKt.startsWith$default((String)(line = (String)iterator2.next()), (String)PATCH_CONTENT_START, (boolean)false, (int)2, null) && !StringsKt.startsWith((String)line, (String)CO_AUTHOR_LINE, (boolean)true)) {
                    if (reading && !StringsKt.isBlank((CharSequence)line) && !StringsKt.startsWith$default((CharSequence)line, (char)'#', (boolean)false, (int)2, null)) {
                        result2.add(line);
                    }
                    if (!StringsKt.startsWith$default((String)line, (String)start, (boolean)false, (int)2, null)) continue;
                    reading = true;
                }
                bufferedReader = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return CollectionsKt.sorted((Iterable)result2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/papermc/paperweight/tasks/CollectATsFromPatches$Companion;", "", "()V", "CO_AUTHOR_LINE", "", "PATCH_CONTENT_START", "paperweight-lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

