/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.ZippedTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.FileSystemReference;
import io.papermc.paperweight.util.NioKt;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.data.FileEntry;
import io.papermc.paperweight.util.data.LibraryChange;
import io.papermc.paperweight.util.data.ModuleId;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002/0B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u001c\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0&2\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050'0&2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020-2\u0006\u0010)\u001a\u00020*H\u0016R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u0014\u0010\u001b\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u0014\u0010\u001d\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0014R\u0019\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00061"}, d2={"Lio/papermc/paperweight/tasks/CreateBundlerJar;", "Lio/papermc/paperweight/tasks/ZippedTask;", "()V", "extraManifestMainAttributes", "Lorg/gradle/api/provider/MapProperty;", "", "getExtraManifestMainAttributes", "()Lorg/gradle/api/provider/MapProperty;", "libraryArtifacts", "Lorg/gradle/api/provider/ListProperty;", "Lio/papermc/paperweight/tasks/CreateBundlerJar$LibraryArtifact;", "getLibraryArtifacts", "()Lorg/gradle/api/provider/ListProperty;", "libraryArtifactsFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getLibraryArtifactsFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "libraryChangesJson", "Lorg/gradle/api/file/RegularFileProperty;", "getLibraryChangesJson", "()Lorg/gradle/api/file/RegularFileProperty;", "mainClass", "Lorg/gradle/api/provider/Property;", "getMainClass", "()Lorg/gradle/api/provider/Property;", "paperclip", "getPaperclip", "serverLibrariesList", "getServerLibrariesList", "vanillaBundlerJar", "getVanillaBundlerJar", "versionArtifacts", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lio/papermc/paperweight/tasks/CreateBundlerJar$VersionArtifact;", "getVersionArtifacts", "()Lorg/gradle/api/NamedDomainObjectContainer;", "createVersionArtifactContainer", "handleServerDependencies", "", "Lio/papermc/paperweight/util/data/FileEntry;", "Lio/papermc/paperweight/util/data/ModuleId;", "rootDir", "Ljava/nio/file/Path;", "handleVersions", "init", "", "run", "LibraryArtifact", "VersionArtifact", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nCreateBundlerJar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateBundlerJar.kt\nio/papermc/paperweight/tasks/CreateBundlerJar\n+ 2 GradleApiKotlinDslExtensions_1cbh1oqkvm762j10e96dawuh5.kt\norg/gradle/kotlin/dsl/GradleApiKotlinDslExtensions_1cbh1oqkvm762j10e96dawuh5Kt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n71#2:239\n1#3:240\n1053#4:241\n1053#4:242\n295#4,2:243\n1557#4:245\n1628#4,3:246\n*S KotlinDebug\n*F\n+ 1 CreateBundlerJar.kt\nio/papermc/paperweight/tasks/CreateBundlerJar\n*L\n91#1:239\n111#1:241\n116#1:242\n144#1:243,2\n187#1:245\n187#1:246,3\n*E\n"})
public abstract class CreateBundlerJar
extends ZippedTask {
    @NotNull
    private final NamedDomainObjectContainer<VersionArtifact> versionArtifacts = this.createVersionArtifactContainer();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getPaperclip();

    @Input
    @NotNull
    public abstract Property<String> getMainClass();

    @Nested
    @NotNull
    public final NamedDomainObjectContainer<VersionArtifact> getVersionArtifacts() {
        return this.versionArtifacts;
    }

    @Nested
    @Optional
    @NotNull
    public abstract ListProperty<LibraryArtifact> getLibraryArtifacts();

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getLibraryArtifactsFiles();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getServerLibrariesList();

    @Classpath
    @NotNull
    public abstract RegularFileProperty getVanillaBundlerJar();

    @Input
    @Optional
    @NotNull
    public abstract MapProperty<String, String> getExtraManifestMainAttributes();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getLibraryChangesJson();

    /*
     * WARNING - void declaration
     */
    private final NamedDomainObjectContainer<VersionArtifact> createVersionArtifactContainer() {
        void elementType$iv;
        void $this$domainObjectContainer$iv;
        ObjectFactory objectFactory = this.getObjects();
        Class<VersionArtifact> clazz = VersionArtifact.class;
        NamedDomainObjectFactory factory$iv = new NamedDomainObjectFactory(this){
            final /* synthetic */ CreateBundlerJar this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final VersionArtifact create(String it) {
                void parameters$iv;
                void $this$newInstance$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ObjectFactory objectFactory = this.this$0.getObjects();
                Object[] objectArray = new Object[]{it};
                boolean $i$f$newInstance = false;
                return (VersionArtifact)$this$newInstance$iv.newInstance(VersionArtifact.class, (Object[])Arrays.copyOf(parameters$iv, ((void)parameters$iv).length));
            }
        };
        boolean $i$f$domainObjectContainer = false;
        NamedDomainObjectContainer namedDomainObjectContainer = $this$domainObjectContainer$iv.domainObjectContainer((Class)elementType$iv, factory$iv);
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectContainer, (String)"`domainObjectContainer`(\u2026entType`.java, `factory`)");
        return namedDomainObjectContainer;
    }

    @Override
    public void init() {
        super.init();
        this.getLibraryChangesJson().convention((Provider)UtilsKt.defaultOutput(this, this.getName() + "-library-changes", "json"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(@NotNull Path rootDir) {
        boolean $i$f$sortedBy;
        Iterable $this$sortedBy$iv;
        Path path3;
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Path path2 = this.getPaperclip().getSingleFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"paperclip.singleFile.toPath()");
        AutoCloseable autoCloseable = NioKt.openZipSafe(path2);
        Throwable throwable = null;
        try {
            FileSystemReference zip2 = (FileSystemReference)autoCloseable;
            boolean path3 = false;
            FileKt.copyRecursivelyTo(zip2.getPath("/"), rootDir);
            zip2 = Unit.INSTANCE;
        }
        catch (Throwable zip2) {
            throwable = zip2;
            throw zip2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        List<FileEntry<String>> versions = this.handleVersions(rootDir);
        List<FileEntry<ModuleId>> libraries = this.handleServerDependencies(rootDir);
        Path it = path3 = rootDir.resolve("META-INF/versions.list");
        boolean bl = false;
        Path path4 = it.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"it.parent");
        Path path5 = path4;
        Object object = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path5, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createDirectories(...)");
        Path versionsFile = path3;
        Object object2 = rootDir.resolve("META-INF/libraries.list");
        Path it2 = object2;
        int n = 0;
        Path path6 = it2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"it.parent");
        object = path6;
        Object object3 = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(object3, ((FileAttribute[])object3).length)), (String)"createDirectories(...)");
        Path librariesFile = object2;
        Intrinsics.checkNotNullExpressionValue((Object)versionsFile, (String)"versionsFile");
        object2 = versionsFile;
        object = new OpenOption[]{};
        Object object4 = Charsets.UTF_8;
        n = 8192;
        object2 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object2, (OpenOption[])Arrays.copyOf(object, ((FileAttribute[])object).length)), (Charset)object4), n);
        object4 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object2;
            boolean bl2 = false;
            $this$sortedBy$iv = versions;
            $i$f$sortedBy = false;
            for (FileEntry v : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    FileEntry it = (FileEntry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getId()));
                    it = (FileEntry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getId()))));
                }
            })) {
                writer.append(v.toString()).append('\n');
            }
            writer = Unit.INSTANCE;
        }
        catch (Throwable writer) {
            object4 = writer;
            throw writer;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object4);
        }
        Intrinsics.checkNotNullExpressionValue((Object)librariesFile, (String)"librariesFile");
        object2 = librariesFile;
        OpenOption[] bl2 = new OpenOption[]{};
        object4 = Charsets.UTF_8;
        int writer = 8192;
        object2 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object2, Arrays.copyOf(bl2, bl2.length)), (Charset)object4), writer);
        object4 = null;
        try {
            BufferedWriter writer2 = (BufferedWriter)object2;
            boolean bl3 = false;
            $this$sortedBy$iv = libraries;
            $i$f$sortedBy = false;
            for (FileEntry l : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    FileEntry it = (FileEntry)a;
                    boolean bl = false;
                    Comparable comparable = (ModuleId)it.getId();
                    it = (FileEntry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((ModuleId)it.getId()));
                }
            })) {
                writer2.append(l.toString()).append('\n');
            }
            writer2 = Unit.INSTANCE;
        }
        catch (Throwable writer2) {
            object4 = writer2;
            throw writer2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object4);
        }
        if (this.getExtraManifestMainAttributes().isPresent()) {
            Path path7 = rootDir.resolve("META-INF/MANIFEST.MF");
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"rootDir.resolve(\"META-INF/MANIFEST.MF\")");
            UtilsKt.modifyManifest$default(path7, false, (Function1)new Function1<Manifest, Unit>(this){
                final /* synthetic */ CreateBundlerJar this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(Manifest $this$modifyManifest) {
                    Intrinsics.checkNotNullParameter((Object)$this$modifyManifest, (String)"$this$modifyManifest");
                    Object object = this.this$0.getExtraManifestMainAttributes().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extraManifestMainAttributes.get()");
                    Map $this$forEach$iv = (Map)object;
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> entry = element$iv = iterator.next();
                        boolean bl = false;
                        String k = (String)entry.getKey();
                        String v = (String)entry.getValue();
                        $this$modifyManifest.getMainAttributes().putValue(k, v);
                    }
                }
            }, 2, null);
        }
        Path path8 = rootDir.resolve("META-INF/main-class");
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"rootDir.resolve(\"META-INF/main-class\")");
        Object object5 = this.getMainClass().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"mainClass.get()");
        PathsKt.writeText$default((Path)path8, (CharSequence)((CharSequence)object5), null, (OpenOption[])new OpenOption[0], (int)2, null);
        object2 = NioKt.openZipSafe(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getVanillaBundlerJar())));
        object4 = null;
        try {
            FileSystemReference fs = (FileSystemReference)object2;
            boolean bl4 = false;
            Path path9 = fs.getPath("/").resolve("version.json");
            Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"fs.getPath(\"/\").resolve(FileEntry.VERSION_JSON)");
            object3 = path9;
            Path path10 = rootDir.resolve("version.json");
            Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"rootDir.resolve(\"version.json\")");
            Path path11 = path10;
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Path path12 = Files.copy((Path)object3, path11, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"copy(...)");
            Path path13 = path12;
        }
        catch (Throwable throwable2) {
            object4 = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)object4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<FileEntry<ModuleId>> handleServerDependencies(Path rootDir) {
        Object id;
        List libraries = new ArrayList();
        List changedLibraries = new ArrayList();
        List serverLibraryEntries2 = FileEntry.Companion.parse(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getServerLibrariesList())), (Function1)new Function1<String, ModuleId>((Object)ModuleId.Companion){

            public final ModuleId invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ModuleId.Companion)this.receiver).parse(p0);
            }
        });
        Path outputDir = rootDir.resolve("META-INF/libraries");
        for (LibraryArtifact dep : (List)this.getLibraryArtifacts().get()) {
            Path jarFile;
            Object v0;
            block9: {
                Iterable $this$firstOrNull$iv = serverLibraryEntries2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FileEntry it = (FileEntry)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)((ModuleId)it.getId()).getGroup(), (Object)dep.getModule().getGroup()) && Intrinsics.areEqual((Object)((ModuleId)it.getId()).getName(), (Object)dep.getModule().getName()) && Intrinsics.areEqual((Object)((ModuleId)it.getId()).getClassifier(), (Object)dep.getModule().getClassifier()))) continue;
                    v0 = element$iv;
                    break block9;
                }
                v0 = null;
            }
            FileEntry serverLibrary = v0;
            if (serverLibrary != null) {
                if (Intrinsics.areEqual((Object)((ModuleId)serverLibrary.getId()).getVersion(), (Object)dep.getModule().getVersion())) {
                    ((Collection)libraries).add(serverLibrary);
                    Path path = outputDir.resolve(dep.getModule().toPath());
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputDir.resolve(dep.module.toPath())");
                    dep.copyTo(path);
                    continue;
                }
                ModuleId newId = dep.getModule();
                String newPath = newId.toPath();
                ((Collection)changedLibraries).add(new LibraryChange((ModuleId)serverLibrary.getId(), serverLibrary.getPath(), newId, newPath));
                Path path = outputDir.resolve(newPath);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputDir.resolve(newPath)");
                jarFile = dep.copyTo(path);
                ((Collection)libraries).add(new FileEntry<ModuleId>(FileKt.sha256asHex(jarFile), newId, newPath));
                continue;
            }
            id = dep.getModule();
            String path = ((ModuleId)id).toPath();
            Path path2 = outputDir.resolve(path);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"outputDir.resolve(path)");
            jarFile = dep.copyTo(path2);
            ((Collection)libraries).add(new FileEntry<Object>(FileKt.sha256asHex(jarFile), id, path));
        }
        Object object = new Object[]{this.getLibraryChangesJson()};
        UtilsKt.ensureParentExists(object);
        object = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getLibraryChangesJson()));
        id = new OpenOption[]{};
        Object object2 = Charsets.UTF_8;
        int serverLibrary = 8192;
        object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, (OpenOption[])Arrays.copyOf(id, ((Object)id).length)), (Charset)object2), serverLibrary);
        object2 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl = false;
            UtilsKt.getGson().toJson((Object)changedLibraries, (Appendable)writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return libraries;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileEntry<String>> handleVersions(Path rootDir) {
        void $this$mapTo$iv$iv;
        Path outputDir = rootDir.resolve("META-INF/versions");
        Iterable $this$map$iv = (Iterable)this.versionArtifacts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void versionArtifact;
            VersionArtifact versionArtifact2 = (VersionArtifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = versionArtifact.getId().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"versionArtifact.id.get()");
            String id = (String)object;
            String versionPath = id + "/" + versionArtifact.getName() + "-" + id + ".jar";
            Path inputFile = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)versionArtifact.getFile()));
            Path outputFile = outputDir.resolve(versionPath);
            Object object2 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)outputFile, (String)"outputFile");
            object2[0] = outputFile;
            UtilsKt.ensureParentExists(object2);
            object2 = inputFile;
            Path path = outputFile;
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object2, path, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
            collection.add(new FileEntry<String>(FileKt.sha256asHex(inputFile), id, versionPath));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lio/papermc/paperweight/tasks/CreateBundlerJar$LibraryArtifact;", "", "()V", "id", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/api/artifacts/component/ComponentArtifactIdentifier;", "getId", "()Lorg/gradle/api/provider/Property;", "module", "Lio/papermc/paperweight/util/data/ModuleId;", "getModule", "()Lio/papermc/paperweight/util/data/ModuleId;", "path", "Lorg/gradle/api/file/RegularFileProperty;", "getPath", "()Lorg/gradle/api/file/RegularFileProperty;", "variant", "Lorg/gradle/api/artifacts/result/ResolvedVariantResult;", "getVariant", "copyTo", "Ljava/nio/file/Path;", "paperweight-lib"})
    public static abstract class LibraryArtifact {
        @Internal
        @NotNull
        public abstract RegularFileProperty getPath();

        @Input
        @NotNull
        public abstract Property<ComponentArtifactIdentifier> getId();

        @Input
        @NotNull
        public abstract Property<ResolvedVariantResult> getVariant();

        @NotNull
        public final Path copyTo(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Object object = new Object[]{path};
            UtilsKt.ensureParentExists(object);
            object = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getPath()));
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Path path2 = Files.copy((Path)object, path, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"copy(...)");
            return path2;
        }

        @Internal
        @NotNull
        public final ModuleId getModule() {
            ModuleId moduleId;
            ComponentIdentifier componentIdentifier = ((ComponentArtifactIdentifier)this.getId().get()).getComponentIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"id.get().componentIdentifier");
            ComponentIdentifier ident = componentIdentifier;
            if (ident instanceof ModuleComponentIdentifier) {
                Object object = this.getId().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"id.get()");
                moduleId = ModuleId.Companion.fromIdentifier((ComponentArtifactIdentifier)object);
            } else if (ident instanceof ProjectComponentIdentifier) {
                String mainCap = (String)((ResolvedVariantResult)this.getVariant().get()).getAttributes().getAttribute(UtilsKt.getMainCapabilityAttribute());
                if (mainCap != null) {
                    moduleId = ModuleId.Companion.parse(mainCap);
                } else {
                    List list = ((ResolvedVariantResult)this.getVariant().get()).getCapabilities();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.get().capabilities");
                    Capability capability = (Capability)CollectionsKt.first((List)list);
                    String string = capability.getVersion();
                    if (string == null) {
                        throw new PaperweightException("Unknown version for " + capability.getGroup() + ":" + capability.getName());
                    }
                    String version = string;
                    String string2 = capability.getGroup();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capability.group");
                    String string3 = capability.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"capability.name");
                    moduleId = new ModuleId(string2, string3, version, null, 8, null);
                }
            } else {
                throw new PaperweightException("Unknown artifact result type: " + ident.getClass().getName());
            }
            return moduleId;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/tasks/CreateBundlerJar$VersionArtifact;", "", "file", "Lorg/gradle/api/file/RegularFileProperty;", "getFile", "()Lorg/gradle/api/file/RegularFileProperty;", "id", "Lorg/gradle/api/provider/Property;", "", "getId", "()Lorg/gradle/api/provider/Property;", "name", "getName", "()Ljava/lang/String;", "paperweight-lib"})
    public static interface VersionArtifact {
        @Input
        @NotNull
        public String getName();

        @Input
        @NotNull
        public Property<String> getId();

        @Classpath
        @NotNull
        public RegularFileProperty getFile();
    }
}

