/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.tasks.GenerateDevBundle;
import io.papermc.paperweight.tasks.TinyRemapper;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.MavenDep;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import paper.libs.codechicken.diffpatch.cli.DiffOperation;
import paper.libs.codechicken.diffpatch.util.LogLevel;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 32\u00020\u0001:\u000234B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0002J\b\u0010(\u001a\u00020)H\u0002J\"\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020+H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020+H\u0002J\b\u00102\u001a\u000200H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006R\u0014\u0010\u0016\u001a\u00020\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0006R\u0014\u0010\u001c\u001a\u00020\u001d8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lio/papermc/paperweight/tasks/GenerateDevBundle;", "Lio/papermc/paperweight/tasks/BaseTask;", "()V", "devBundleFile", "Lorg/gradle/api/file/RegularFileProperty;", "getDevBundleFile", "()Lorg/gradle/api/file/RegularFileProperty;", "libraryRepositories", "Lorg/gradle/api/provider/ListProperty;", "", "getLibraryRepositories", "()Lorg/gradle/api/provider/ListProperty;", "macheDep", "Lorg/gradle/api/provider/Property;", "getMacheDep", "()Lorg/gradle/api/provider/Property;", "macheUrl", "getMacheUrl", "minecraftVersion", "getMinecraftVersion", "mojangMappedPaperclipFile", "getMojangMappedPaperclipFile", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "reobfMappingsFile", "getReobfMappingsFile", "sourceDirectories", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getSourceDirectories", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "vanillaJavaDir", "Lorg/gradle/api/file/DirectoryProperty;", "getVanillaJavaDir", "()Lorg/gradle/api/file/DirectoryProperty;", "createBundleConfig", "Lio/papermc/paperweight/tasks/GenerateDevBundle$DevBundleConfig;", "dataTargetDir", "patchTargetDir", "createMacheDep", "Lio/papermc/paperweight/util/MavenDep;", "diffFiles", "Ljava/nio/file/Path;", "fileName", "original", "patched", "generatePatches", "", "output", "run", "Companion", "DevBundleConfig", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nGenerateDevBundle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateDevBundle.kt\nio/papermc/paperweight/tasks/GenerateDevBundle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
public abstract class GenerateDevBundle
extends BaseTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String reobfMappingsFileName = "mojang-spigot-reobf.tiny";
    @NotNull
    public static final String mojangMappedPaperclipFileName = "paperclip-mojang.jar";
    public static final int currentDataVersion = 7;

    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getSourceDirectories();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getVanillaJavaDir();

    @Input
    @NotNull
    public abstract Property<String> getMinecraftVersion();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getMojangMappedPaperclipFile();

    @Input
    @NotNull
    public abstract ListProperty<String> getLibraryRepositories();

    @Input
    @NotNull
    public abstract Property<String> getMacheUrl();

    @Input
    @NotNull
    public abstract Property<String> getMacheDep();

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getReobfMappingsFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getDevBundleFile();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void run() {
        Path path = this.getTemporaryDir().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"temporaryDir.toPath()");
        FileKt.deleteRecursive$default(path, null, null, 3, null);
        Path path2 = this.getTemporaryDir().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"temporaryDir.toPath()");
        Path path3 = path2;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path devBundle = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getDevBundleFile()));
        FileKt.deleteForcefully(devBundle);
        FileKt.createParentDirectories(devBundle, new FileAttribute[0]);
        Path tempPatchDir = this.getTemporaryDir().toPath().resolve("patches");
        Intrinsics.checkNotNullExpressionValue((Object)tempPatchDir, (String)"tempPatchDir");
        this.generatePatches(tempPatchDir);
        String dataDir = "data";
        String patchesDir = "patches";
        DevBundleConfig config = this.createBundleConfig(dataDir, patchesDir);
        Closeable closeable = FileKt.writeZip(devBundle);
        Throwable throwable = null;
        try {
            CopyOption[] copyOptionArray;
            Object object;
            FileSystem zip2 = (FileSystem)closeable;
            boolean bl = false;
            Path path4 = zip2.getPath("config.json", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"zip.getPath(\"config.json\")");
            Object object2 = path4;
            Object object3 = Charsets.UTF_8;
            OpenOption[] openOptionArray = new OpenOption[]{};
            int n = 8192;
            object2 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object2, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object3), n);
            object3 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object2;
                boolean bl2 = false;
                UtilsKt.getGson().toJson((Object)config, (Appendable)writer);
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                object3 = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
            Path path5 = zip2.getPath("data-version.txt", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"zip.getPath(\"data-version.txt\")");
            PathsKt.writeText$default((Path)path5, (CharSequence)"7", null, (OpenOption[])new OpenOption[0], (int)2, null);
            Path dataZip = zip2.getPath(dataDir, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)dataZip, (String)"dataZip");
            FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(dataZip, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createDirectories(...)");
            if (this.getReobfMappingsFile().isPresent()) {
                object3 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getReobfMappingsFile()));
                Path path6 = dataZip.resolve(reobfMappingsFileName);
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"dataZip.resolve(reobfMappingsFileName)");
                object = path6;
                copyOptionArray = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object3, (Path)object, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
            }
            object3 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getMojangMappedPaperclipFile()));
            Path path7 = dataZip.resolve(mojangMappedPaperclipFileName);
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"dataZip.resolve(mojangMappedPaperclipFileName)");
            object = path7;
            copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object3, (Path)object, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
            Path patchesZip = zip2.getPath(patchesDir, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)patchesZip, (String)"patchesZip");
            FileKt.copyRecursivelyTo(tempPatchDir, patchesZip);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Path path8 = this.getTemporaryDir().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"temporaryDir.toPath()");
        FileKt.deleteRecursive$default(path8, null, null, 3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generatePatches(Path output) {
        Path workingDir = this.getTemporaryDir().toPath().resolve("work");
        Intrinsics.checkNotNullExpressionValue((Object)workingDir, (String)"workingDir");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(workingDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        this.getSourceDirectories().getAsFileTree().visit(new Action(this, workingDir){
            final /* synthetic */ GenerateDevBundle this$0;
            final /* synthetic */ Path $workingDir;
            {
                this.this$0 = $receiver;
                this.$workingDir = $workingDir;
            }

            public final void execute(FileVisitDetails $this$visit) {
                Intrinsics.checkNotNullParameter((Object)$this$visit, (String)"$this$visit");
                Path path = $this$visit.getFile().toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toPath()");
                Path path2 = path.toAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
                Path path3 = path2.normalize();
                Path path4 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.this$0.getVanillaJavaDir())).toAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toAbsolutePath(...)");
                if (path3.startsWith(path4.normalize())) {
                    return;
                }
                if ($this$visit.getFile().isDirectory()) {
                    Path path5 = this.$workingDir.resolve($this$visit.getPath());
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"workingDir.resolve(path)");
                    Path path6 = path5;
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path6, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                } else {
                    Path path7 = $this$visit.getFile().toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"file.toPath()");
                    Path path8 = path7;
                    Path path9 = this.$workingDir.resolve($this$visit.getPath());
                    Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"workingDir.resolve(path)");
                    Path path10 = path9;
                    CopyOption[] copyOptionArray = new CopyOption[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path8, path10, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
                }
            }
        });
        Path path = workingDir.resolve(".git");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"workingDir.resolve(\".git\")");
        FileKt.deleteRecursive$default(path, null, null, 3, null);
        AutoCloseable autoCloseable = Files.walk(workingDir, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            Path oldSrc = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getVanillaJavaDir()));
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                Path path2;
                Path file2 = (Path)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(file2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                Path relativeFile = PathsKt.relativeTo((Path)file2, (Path)workingDir);
                String relativeFilePath = PathsKt.getInvariantSeparatorsPathString((Path)relativeFile);
                Path decompFile = oldSrc.resolve(relativeFilePath);
                Intrinsics.checkNotNullExpressionValue((Object)decompFile, (String)"decompFile");
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.exists(decompFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    Path path3;
                    String patchName = PathsKt.getName((Path)relativeFile) + ".patch";
                    Path outputFile = output.resolve(relativeFilePath).resolveSibling(patchName);
                    path2 = this.diffFiles(relativeFilePath, decompFile, file2);
                    if (path2 != null) {
                        Path path4 = path2;
                        Intrinsics.checkNotNullExpressionValue((Object)outputFile, (String)"outputFile");
                        Path path5 = FileKt.createParentDirectories(outputFile, new FileAttribute[0]);
                        CopyOption[] copyOptionArray = new CopyOption[]{};
                        Path path6 = Files.copy(path4, path5, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
                        path3 = path6;
                        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"copy(...)");
                        continue;
                    }
                    path3 = null;
                    continue;
                }
                Path outputFile = output.resolve(relativeFilePath);
                Path path7 = file2;
                Intrinsics.checkNotNullExpressionValue((Object)outputFile, (String)"outputFile");
                path2 = FileKt.createParentDirectories(outputFile, new FileAttribute[0]);
                CopyOption[] copyOptionArray = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path7, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path diffFiles(String fileName, Path original, Path patched) {
        Path dir2 = this.getTemporaryDir().toPath().resolve("diff-work");
        Intrinsics.checkNotNullExpressionValue((Object)dir2, (String)"dir");
        FileKt.deleteRecursive$default(dir2, null, null, 3, null);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(dir2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path a = dir2.resolve("a");
        Path path = a.resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"a.resolve(fileName)");
        Path oldFile = FileKt.createParentDirectories(path, new FileAttribute[0]);
        Path b = dir2.resolve("b");
        Path path2 = b.resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"b.resolve(fileName)");
        Path newFile = FileKt.createParentDirectories(path2, new FileAttribute[0]);
        Path patchOut = dir2.resolve("out");
        Path path3 = original;
        CopyOption[] copyOptionArray = new CopyOption[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path3, oldFile, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        path3 = patched;
        copyOptionArray = new CopyOption[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path3, newFile, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        Path path4 = this.getTemporaryDir().toPath().resolve("diff-log/" + StringsKt.replace$default((String)fileName, (String)"/", (String)"_", (boolean)false, (int)4, null) + ".txt");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"temporaryDir.toPath().re\u2026.replace(\"/\", \"_\")}.txt\")");
        Path logFile = FileKt.createParentDirectories(path4, new FileAttribute[0]);
        Object object = new PrintStream(logFile.toFile(), Charsets.UTF_8);
        Throwable throwable = null;
        try {
            Object logOut = (PrintStream)object;
            boolean bl = false;
            logOut = DiffOperation.builder().logTo((PrintStream)logOut).aPath(a).bPath(b).outputPath(patchOut, null).autoHeader(true).level(LogLevel.ALL).lineEnding("\n").context(3).summary(true).build().operate();
        }
        catch (Throwable logOut) {
            throwable = logOut;
            throw logOut;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Object it = object = patchOut.resolve(fileName + ".patch");
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile((Path)it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? object : null;
    }

    private final DevBundleConfig createBundleConfig(String dataTargetDir, String patchTargetDir) {
        Object object = this.getMinecraftVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"minecraftVersion.get()");
        String string = (String)object;
        MavenDep mavenDep = this.createMacheDep();
        String string2 = this.getReobfMappingsFile().isPresent() ? dataTargetDir + "/mojang-spigot-reobf.tiny" : null;
        String string3 = dataTargetDir + "/paperclip-mojang.jar";
        Object object2 = this.getLibraryRepositories().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"libraryRepositories.get()");
        return new DevBundleConfig(string, mavenDep, patchTargetDir, string2, string3, (List)object2, TinyRemapper.INSTANCE.getPluginRemapArgs());
    }

    private final MavenDep createMacheDep() {
        Object object = this.getMacheUrl().zip((Provider)this.getMacheDep(), (BiFunction)createMacheDep.1.INSTANCE).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"macheUrl.zip(macheDep) {\u2026url, listOf(dep)) }.get()");
        return (MavenDep)object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/papermc/paperweight/tasks/GenerateDevBundle$Companion;", "", "()V", "currentDataVersion", "", "mojangMappedPaperclipFileName", "", "reobfMappingsFileName", "paperweight-lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0003J]\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006%"}, d2={"Lio/papermc/paperweight/tasks/GenerateDevBundle$DevBundleConfig;", "", "minecraftVersion", "", "mache", "Lio/papermc/paperweight/util/MavenDep;", "patchDir", "reobfMappingsFile", "mojangMappedPaperclipFile", "libraryRepositories", "", "pluginRemapArgs", "(Ljava/lang/String;Lio/papermc/paperweight/util/MavenDep;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getLibraryRepositories", "()Ljava/util/List;", "getMache", "()Lio/papermc/paperweight/util/MavenDep;", "getMinecraftVersion", "()Ljava/lang/String;", "getMojangMappedPaperclipFile", "getPatchDir", "getPluginRemapArgs", "getReobfMappingsFile", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "paperweight-lib"})
    public static final class DevBundleConfig {
        @NotNull
        private final String minecraftVersion;
        @NotNull
        private final MavenDep mache;
        @NotNull
        private final String patchDir;
        @Nullable
        private final String reobfMappingsFile;
        @NotNull
        private final String mojangMappedPaperclipFile;
        @NotNull
        private final List<String> libraryRepositories;
        @NotNull
        private final List<String> pluginRemapArgs;

        public DevBundleConfig(@NotNull String minecraftVersion2, @NotNull MavenDep mache, @NotNull String patchDir, @Nullable String reobfMappingsFile, @NotNull String mojangMappedPaperclipFile, @NotNull List<String> libraryRepositories, @NotNull List<String> pluginRemapArgs) {
            Intrinsics.checkNotNullParameter((Object)minecraftVersion2, (String)"minecraftVersion");
            Intrinsics.checkNotNullParameter((Object)mache, (String)"mache");
            Intrinsics.checkNotNullParameter((Object)patchDir, (String)"patchDir");
            Intrinsics.checkNotNullParameter((Object)mojangMappedPaperclipFile, (String)"mojangMappedPaperclipFile");
            Intrinsics.checkNotNullParameter(libraryRepositories, (String)"libraryRepositories");
            Intrinsics.checkNotNullParameter(pluginRemapArgs, (String)"pluginRemapArgs");
            this.minecraftVersion = minecraftVersion2;
            this.mache = mache;
            this.patchDir = patchDir;
            this.reobfMappingsFile = reobfMappingsFile;
            this.mojangMappedPaperclipFile = mojangMappedPaperclipFile;
            this.libraryRepositories = libraryRepositories;
            this.pluginRemapArgs = pluginRemapArgs;
        }

        @NotNull
        public final String getMinecraftVersion() {
            return this.minecraftVersion;
        }

        @NotNull
        public final MavenDep getMache() {
            return this.mache;
        }

        @NotNull
        public final String getPatchDir() {
            return this.patchDir;
        }

        @Nullable
        public final String getReobfMappingsFile() {
            return this.reobfMappingsFile;
        }

        @NotNull
        public final String getMojangMappedPaperclipFile() {
            return this.mojangMappedPaperclipFile;
        }

        @NotNull
        public final List<String> getLibraryRepositories() {
            return this.libraryRepositories;
        }

        @NotNull
        public final List<String> getPluginRemapArgs() {
            return this.pluginRemapArgs;
        }

        @NotNull
        public final String component1() {
            return this.minecraftVersion;
        }

        @NotNull
        public final MavenDep component2() {
            return this.mache;
        }

        @NotNull
        public final String component3() {
            return this.patchDir;
        }

        @Nullable
        public final String component4() {
            return this.reobfMappingsFile;
        }

        @NotNull
        public final String component5() {
            return this.mojangMappedPaperclipFile;
        }

        @NotNull
        public final List<String> component6() {
            return this.libraryRepositories;
        }

        @NotNull
        public final List<String> component7() {
            return this.pluginRemapArgs;
        }

        @NotNull
        public final DevBundleConfig copy(@NotNull String minecraftVersion2, @NotNull MavenDep mache, @NotNull String patchDir, @Nullable String reobfMappingsFile, @NotNull String mojangMappedPaperclipFile, @NotNull List<String> libraryRepositories, @NotNull List<String> pluginRemapArgs) {
            Intrinsics.checkNotNullParameter((Object)minecraftVersion2, (String)"minecraftVersion");
            Intrinsics.checkNotNullParameter((Object)mache, (String)"mache");
            Intrinsics.checkNotNullParameter((Object)patchDir, (String)"patchDir");
            Intrinsics.checkNotNullParameter((Object)mojangMappedPaperclipFile, (String)"mojangMappedPaperclipFile");
            Intrinsics.checkNotNullParameter(libraryRepositories, (String)"libraryRepositories");
            Intrinsics.checkNotNullParameter(pluginRemapArgs, (String)"pluginRemapArgs");
            return new DevBundleConfig(minecraftVersion2, mache, patchDir, reobfMappingsFile, mojangMappedPaperclipFile, libraryRepositories, pluginRemapArgs);
        }

        public static /* synthetic */ DevBundleConfig copy$default(DevBundleConfig devBundleConfig, String string, MavenDep mavenDep, String string2, String string3, String string4, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = devBundleConfig.minecraftVersion;
            }
            if ((n & 2) != 0) {
                mavenDep = devBundleConfig.mache;
            }
            if ((n & 4) != 0) {
                string2 = devBundleConfig.patchDir;
            }
            if ((n & 8) != 0) {
                string3 = devBundleConfig.reobfMappingsFile;
            }
            if ((n & 0x10) != 0) {
                string4 = devBundleConfig.mojangMappedPaperclipFile;
            }
            if ((n & 0x20) != 0) {
                list = devBundleConfig.libraryRepositories;
            }
            if ((n & 0x40) != 0) {
                list2 = devBundleConfig.pluginRemapArgs;
            }
            return devBundleConfig.copy(string, mavenDep, string2, string3, string4, list, list2);
        }

        @NotNull
        public String toString() {
            return "DevBundleConfig(minecraftVersion=" + this.minecraftVersion + ", mache=" + this.mache + ", patchDir=" + this.patchDir + ", reobfMappingsFile=" + this.reobfMappingsFile + ", mojangMappedPaperclipFile=" + this.mojangMappedPaperclipFile + ", libraryRepositories=" + this.libraryRepositories + ", pluginRemapArgs=" + this.pluginRemapArgs + ")";
        }

        public int hashCode() {
            int result2 = this.minecraftVersion.hashCode();
            result2 = result2 * 31 + this.mache.hashCode();
            result2 = result2 * 31 + this.patchDir.hashCode();
            result2 = result2 * 31 + (this.reobfMappingsFile == null ? 0 : this.reobfMappingsFile.hashCode());
            result2 = result2 * 31 + this.mojangMappedPaperclipFile.hashCode();
            result2 = result2 * 31 + ((Object)this.libraryRepositories).hashCode();
            result2 = result2 * 31 + ((Object)this.pluginRemapArgs).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DevBundleConfig)) {
                return false;
            }
            DevBundleConfig devBundleConfig = (DevBundleConfig)other;
            if (!Intrinsics.areEqual((Object)this.minecraftVersion, (Object)devBundleConfig.minecraftVersion)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mache, (Object)devBundleConfig.mache)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.patchDir, (Object)devBundleConfig.patchDir)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.reobfMappingsFile, (Object)devBundleConfig.reobfMappingsFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mojangMappedPaperclipFile, (Object)devBundleConfig.mojangMappedPaperclipFile)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.libraryRepositories, devBundleConfig.libraryRepositories)) {
                return false;
            }
            return Intrinsics.areEqual(this.pluginRemapArgs, devBundleConfig.pluginRemapArgs);
        }
    }
}

