/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.ControllableOutputTask;
import io.papermc.paperweight.tasks.RebuildGitPatches;
import io.papermc.paperweight.util.Command;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import paper.libs.org.jetbrains.annotations.NotNull;

@UntrackedTask(because="RebuildGitPatches should always run when requested")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lio/papermc/paperweight/tasks/RebuildGitPatches;", "Lio/papermc/paperweight/tasks/ControllableOutputTask;", "()V", "baseRef", "Lorg/gradle/api/provider/Property;", "", "getBaseRef", "()Lorg/gradle/api/provider/Property;", "filterPatches", "", "getFilterPatches", "inputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "patchDir", "getPatchDir", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "cleanupPatches", "", "git", "Lio/papermc/paperweight/util/Git;", "init", "run", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nRebuildGitPatches.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RebuildGitPatches.kt\nio/papermc/paperweight/tasks/RebuildGitPatches\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,164:1\n1#2:165\n1863#3,2:166\n1557#3:168\n1628#3,3:169\n1557#3:174\n1628#3,3:175\n37#4,2:172\n37#4,2:178\n*S KotlinDebug\n*F\n+ 1 RebuildGitPatches.kt\nio/papermc/paperweight/tasks/RebuildGitPatches\n*L\n145#1:166,2\n152#1:168\n152#1:169,3\n153#1:174\n153#1:175,3\n152#1:172,2\n153#1:178,2\n*E\n"})
public abstract class RebuildGitPatches
extends ControllableOutputTask {
    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getInputDir();

    @Input
    @NotNull
    public abstract Property<String> getBaseRef();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getPatchDir();

    @Input
    @NotNull
    public abstract Property<Boolean> getFilterPatches();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders();

    @Override
    public void init() {
        this.getPrintOutput().convention((Object)true);
        this.getFilterPatches().convention(this.getProviders().gradleProperty("paperweight.filter-patches").map((Transformer)init.1.INSTANCE).orElse((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @TaskAction
    public final void run() {
        block15: {
            block16: {
                what = PathsKt.getName((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir())));
                patchFolder = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getPatchDir()));
                v0 = new LinkOption[]{};
                if (!Files.exists(patchFolder, Arrays.copyOf(v0, v0.length))) {
                    v1 = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(patchFolder, Arrays.copyOf(v1, v1.length)), (String)"createDirectories(...)");
                }
                v2 = this.getPrintOutput().get();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"printOutput.get()");
                if (((Boolean)v2).booleanValue()) {
                    this.getLogger().lifecycle("Formatting patches for " + what + "...");
                }
                v3 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir())).resolve(".git/rebase-apply");
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"inputDir.path.resolve(\".git/rebase-apply\")");
                var3_3 = v3;
                var4_5 = new LinkOption[]{};
                if (!Files.exists(var3_3, Arrays.copyOf(var4_5, var4_5.length))) break block16;
                v4 = this.getPrintOutput().get();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"printOutput.get()");
                if (!((Boolean)v4).booleanValue()) break block15;
                this.getLogger().lifecycle("REBASE DETECTED - PARTIAL SAVE");
                v5 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir())).resolve(".git/rebase-apply/last");
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"inputDir.path.resolve(\".git/rebase-apply/last\")");
                last = Integer.parseInt(StringsKt.trim((CharSequence)PathsKt.readText$default((Path)v5, null, (int)1, null)).toString());
                v6 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir())).resolve(".git/rebase-apply/next");
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"inputDir.path.resolve(\".git/rebase-apply/next\")");
                next = Integer.parseInt(StringsKt.trim((CharSequence)PathsKt.readText$default((Path)v6, null, (int)1, null)).toString());
                var6_7 = patchFolder;
                var7_9 = Files.newDirectoryStream(var6_7, "*.patch");
                var8_10 = null;
                try {
                    var9_11 = (DirectoryStream)var7_9;
                    Intrinsics.checkNotNull((Object)var9_11);
                    it = CollectionsKt.asSequence((Iterable)var9_11);
                    $i$a$-useDirectoryEntries-RebuildGitPatches$run$orderedFiles$1 = false;
                    var9_11 = SequencesKt.toMutableList((Sequence)it);
                }
                catch (Throwable var9_12) {
                    var8_10 = var9_12;
                    throw var9_12;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var7_9, (Throwable)var8_10);
                }
                orderedFiles = var9_11;
                CollectionsKt.sort((List)orderedFiles);
                i = 1;
                if (i <= last) {
                    while (true) {
                        if (i < next) {
                            FileKt.deleteForcefully((Path)orderedFiles.get(i));
                        }
                        if (i != last) {
                            ++i;
                            continue;
                        } else {
                            ** GOTO lbl-1000
                        }
                        break;
                    }
                }
                break block15;
lbl-1000:
                // 2 sources

                {
                    break block15;
                }
            }
            FileKt.deleteRecursive$default(patchFolder, null, null, 3, null);
            v7 = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(patchFolder, Arrays.copyOf(v7, v7.length)), (String)"createDirectories(...)");
        }
        git = new Git(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir())), null, 2, null);
        next = new String[]{"fetch", "--all", "--prune"};
        Command.runSilently$default(git.invoke(next), false, true, 1, null);
        next = new String[10];
        next[0] = "format-patch";
        next[1] = "--diff-algorithm=myers";
        next[2] = "--zero-commit";
        next[3] = "--full-index";
        next[4] = "--no-signature";
        next[5] = "--no-stat";
        next[6] = "-N";
        next[7] = "-o";
        next[8] = patchFolder.toAbsolutePath().toString();
        Intrinsics.checkNotNullExpressionValue((Object)this.getBaseRef().get(), (String)"baseRef.get()");
        Command.executeSilently$default(git.invoke(next), false, false, 3, null);
        patchDirGit = new Git(patchFolder, null, 2, null);
        orderedFiles = new String[]{"add", "-A", "."};
        Command.executeSilently$default(patchDirGit.invoke((String)orderedFiles), false, false, 3, null);
        v8 = this.getFilterPatches().get();
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"filterPatches.get()");
        if (((Boolean)v8).booleanValue()) {
            this.cleanupPatches(patchDirGit);
        } else {
            v9 = this.getPrintOutput().get();
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"printOutput.get()");
            if (((Boolean)v9).booleanValue()) {
                saved = PathsKt.listDirectoryEntries((Path)patchFolder, (String)"*.patch").size();
                v10 = this.getLogger();
                v11 = this.getLayout().getProjectDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"layout.projectDirectory");
                v10.lifecycle("Saved " + saved + " patches for " + what + " to " + FileKt.getPath((FileSystemLocation)v11).relativize(patchFolder) + "/");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void cleanupPatches(Git git) {
        SpreadBuilder spreadBuilder;
        Iterable iterable;
        Path path = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getPatchDir()));
        Closeable closeable = Files.newDirectoryStream(path, "*.patch");
        Object object = null;
        try {
            iterable = (DirectoryStream)closeable;
            Intrinsics.checkNotNull((Object)iterable);
            Sequence it = CollectionsKt.asSequence((Iterable)iterable);
            boolean bl = false;
            iterable = SequencesKt.toMutableList((Sequence)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Iterable patchFiles = iterable;
        if (patchFiles.isEmpty()) {
            return;
        }
        CollectionsKt.sort(patchFiles);
        ConcurrentLinkedQueue<Path> noChangesPatches = new ConcurrentLinkedQueue<Path>();
        List futures = new ArrayList();
        ExecutorService executor = Executors.newWorkStealingPool();
        try {
            for (Path patch : patchFiles) {
                ((Collection)futures).add(executor.submit(new Runnable(git, patch, noChangesPatches){
                    final /* synthetic */ Git $git;
                    final /* synthetic */ Path $patch;
                    final /* synthetic */ ConcurrentLinkedQueue<Path> $noChangesPatches;
                    {
                        this.$git = $git;
                        this.$patch = $patch;
                        this.$noChangesPatches = $noChangesPatches;
                    }

                    public final void run() {
                        boolean hasNoChanges2;
                        block2: {
                            boolean bl;
                            String[] stringArray = new String[]{"diff", "--diff-algorithm=myers", "--staged", PathsKt.getName((Path)this.$patch)};
                            Sequence $this$all$iv = SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)StringsKt.lineSequence((CharSequence)this.$git.invoke(stringArray).getText()), (Function1)cleanupPatches.hasNoChanges.1.INSTANCE), (Function1)cleanupPatches.hasNoChanges.2.INSTANCE);
                            boolean $i$f$all = false;
                            for (E element$iv : $this$all$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                if (StringsKt.startsWith$default((String)it, (String)"+index", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"-index", (boolean)false, (int)2, null)) continue;
                                bl = false;
                                break block2;
                            }
                            bl = hasNoChanges2 = true;
                        }
                        if (hasNoChanges2) {
                            this.$noChangesPatches.add(this.$patch);
                        }
                    }
                }));
            }
            Iterable $this$forEach$iv = futures;
            boolean $i$f$forEach = false;
            spreadBuilder = $this$forEach$iv.iterator();
            while (spreadBuilder.hasNext()) {
                Object element$iv = spreadBuilder.next();
                Future it = (Future)element$iv;
                boolean bl = false;
                it.get();
            }
        }
        finally {
            executor.shutdownNow();
        }
        if (!((Collection)noChangesPatches).isEmpty()) {
            for (List chunk : CollectionsKt.chunked((Iterable)noChangesPatches, (int)50)) {
                Iterable $this$toTypedArray$iv;
                Path it;
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                Collection<String> $this$map$iv;
                spreadBuilder = new SpreadBuilder(3);
                spreadBuilder.add((Object)"reset");
                spreadBuilder.add((Object)"HEAD");
                Iterable element$iv = chunk;
                SpreadBuilder spreadBuilder2 = spreadBuilder;
                Git git2 = git;
                boolean $i$f$map = false;
                void bl = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Path path2 = (Path)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(PathsKt.getName((Path)it));
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                Iterable thisCollection$iv = $this$toTypedArray$iv;
                spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new String[0]));
                Command.executeSilently$default(git2.invoke((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])), false, false, 3, null);
                spreadBuilder = new SpreadBuilder(3);
                spreadBuilder.add((Object)"checkout");
                spreadBuilder.add((Object)"--");
                $this$toTypedArray$iv = chunk;
                spreadBuilder2 = spreadBuilder;
                git2 = git;
                $i$f$map = false;
                thisCollection$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Path)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(PathsKt.getName((Path)it));
                }
                $this$map$iv = collection = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new String[0]));
                Command.executeSilently$default(git2.invoke((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])), false, false, 3, null);
            }
        }
        Object object2 = this.getPrintOutput().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"printOutput.get()");
        if (((Boolean)object2).booleanValue()) {
            int saved = patchFiles.size() - noChangesPatches.size();
            Directory directory = this.getLayout().getProjectDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"layout.projectDirectory");
            Path relDir = FileKt.getPath((FileSystemLocation)directory).relativize(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getPatchDir())));
            this.getLogger().lifecycle("Saved modified patches (" + saved + "/" + patchFiles.size() + ") for " + PathsKt.getName((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir()))) + " to " + relDir + "/");
        }
    }
}

