/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.util.ClassNodeCache;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.JarProcessing;
import io.papermc.paperweight.util.Relocation;
import io.papermc.paperweight.util.RelocationWrapper;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;
import paper.libs.org.objectweb.asm.ClassVisitor;
import paper.libs.org.objectweb.asm.MethodVisitor;
import paper.libs.org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001a"}, d2={"Lio/papermc/paperweight/tasks/RelocateClassNameConstants;", "Lio/papermc/paperweight/tasks/BaseTask;", "()V", "inputJar", "Lorg/gradle/api/file/RegularFileProperty;", "getInputJar", "()Lorg/gradle/api/file/RegularFileProperty;", "outputJar", "getOutputJar", "processOnly", "Lorg/gradle/api/provider/ListProperty;", "", "getProcessOnly", "()Lorg/gradle/api/provider/ListProperty;", "relocations", "Lio/papermc/paperweight/tasks/RelocateClassNameConstants$RelocationInput;", "getRelocations", "relocate", "", "fromPackage", "toPackage", "op", "Lorg/gradle/api/Action;", "run", "ConstantRelocatingClassVisitor", "RelocationInput", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nRelocateClassNameConstants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelocateClassNameConstants.kt\nio/papermc/paperweight/tasks/RelocateClassNameConstants\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n50#2:147\n1557#3:148\n1628#3,3:149\n1557#3:152\n1628#3,3:153\n*S KotlinDebug\n*F\n+ 1 RelocateClassNameConstants.kt\nio/papermc/paperweight/tasks/RelocateClassNameConstants\n*L\n62#1:147\n84#1:148\n84#1:149,3\n89#1:152\n89#1:153,3\n*E\n"})
public abstract class RelocateClassNameConstants
extends BaseTask {
    public RelocateClassNameConstants() {
        this.getOutputJar().convention((Provider)UtilsKt.defaultOutput(this));
        Object[] objectArray = new String[]{"org/bukkit/craftbukkit/**/*.class", "org/bukkit/craftbukkit/*.class"};
        this.getProcessOnly().convention((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @InputFile
    @NotNull
    public abstract RegularFileProperty getInputJar();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJar();

    @Nested
    @Optional
    @NotNull
    public abstract ListProperty<RelocationInput> getRelocations();

    @Input
    @Optional
    @NotNull
    public abstract ListProperty<String> getProcessOnly();

    /*
     * WARNING - void declaration
     */
    public final void relocate(@NotNull String fromPackage, @NotNull String toPackage, @NotNull Action<RelocationInput> op2) {
        void $this$relocate_u24lambda_u240;
        void $this$newInstance$iv;
        Intrinsics.checkNotNullParameter((Object)fromPackage, (String)"fromPackage");
        Intrinsics.checkNotNullParameter((Object)toPackage, (String)"toPackage");
        Intrinsics.checkNotNullParameter(op2, (String)"op");
        Object object = this.getObjects();
        Object parameters$iv = new Object[]{};
        boolean $i$f$newInstance = false;
        object = $this$newInstance$iv.newInstance(RelocationInput.class, Arrays.copyOf(parameters$iv, ((Object[])parameters$iv).length));
        parameters$iv = (RelocationInput)object;
        ListProperty<RelocationInput> listProperty = this.getRelocations();
        boolean bl = false;
        $this$relocate_u24lambda_u240.getFromPackage().set((Object)fromPackage);
        $this$relocate_u24lambda_u240.getToPackage().set((Object)toPackage);
        op2.execute((Object)$this$relocate_u24lambda_u240);
        listProperty.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void run() {
        void $this$mapTo$iv$iv;
        FileKt.deleteForcefully(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar())));
        Path path = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar())).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputJar.path.parent");
        Path path2 = path;
        Object object = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createDirectories(...)");
        Object object2 = this.getRelocations().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"relocations.get()");
        Iterable $this$map$iv = (Iterable)object2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RelocationInput relocationInput = (RelocationInput)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object3 = it.getFromPackage().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"it.fromPackage.get()");
            String string = (String)object3;
            Object object4 = it.getToPackage().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it.toPackage.get()");
            collection.add(new RelocationWrapper(new Relocation(null, string, (String)object4, CollectionsKt.emptyList()), null, null, null, null, 30, null));
        }
        List relocations = (List)destination$iv$iv;
        object = FileKt.writeZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar())));
        Throwable throwable = null;
        try {
            FileSystem outputFs = (FileSystem)object;
            boolean bl = false;
            Closeable closeable = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputJar())));
            Object object5 = null;
            try {
                void $this$mapTo$iv$iv2;
                FileSystem inputFs = (FileSystem)closeable;
                boolean bl2 = false;
                Object object6 = this.getProcessOnly().getOrElse((Object)CollectionsKt.emptyList());
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"processOnly.getOrElse(emptyList())");
                Iterable $this$map$iv2 = (Iterable)object6;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(inputFs.getPathMatcher("glob:" + (String)(StringsKt.startsWith$default((CharSequence)((CharSequence)it), (char)'/', (boolean)false, (int)2, null) ? it : "/" + (String)it)));
                }
                List includes = (List)destination$iv$iv2;
                JarProcessing.INSTANCE.processJar(inputFs, outputFs, new JarProcessing.ClassProcessor.VisitorBased(includes, relocations){
                    final /* synthetic */ List<PathMatcher> $includes;
                    final /* synthetic */ List<RelocationWrapper> $relocations;
                    {
                        this.$includes = $includes;
                        this.$relocations = $relocations;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean shouldProcess(Path file2) {
                        PathMatcher it;
                        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                        if (this.$includes.isEmpty()) return true;
                        Iterable $this$any$iv = this.$includes;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            return false;
                        }
                        Iterator<T> iterator = $this$any$iv.iterator();
                        do {
                            if (!iterator.hasNext()) return false;
                            T element$iv = iterator.next();
                            it = (PathMatcher)element$iv;
                            boolean bl = false;
                        } while (!it.matches(file2));
                        return true;
                    }

                    public ClassVisitor processClass(ClassNode node, ClassVisitor parent, ClassNodeCache classNodeCache) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                        Intrinsics.checkNotNullParameter((Object)classNodeCache, (String)"classNodeCache");
                        return new ConstantRelocatingClassVisitor(parent, this.$relocations);
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                try {
                    object5 = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)closeable, object5);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object5);
            iterable = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006JE\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0010\u0010\u000f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/papermc/paperweight/tasks/RelocateClassNameConstants$ConstantRelocatingClassVisitor;", "Lpaper/libs/org/objectweb/asm/ClassVisitor;", "parent", "relocations", "", "Lio/papermc/paperweight/util/RelocationWrapper;", "(Lorg/objectweb/asm/ClassVisitor;Ljava/util/List;)V", "visitMethod", "Lpaper/libs/org/objectweb/asm/MethodVisitor;", "access", "", "name", "", "descriptor", "signature", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "paperweight-lib"})
    private static final class ConstantRelocatingClassVisitor
    extends ClassVisitor {
        @NotNull
        private final List<RelocationWrapper> relocations;

        public ConstantRelocatingClassVisitor(@NotNull ClassVisitor parent, @NotNull List<RelocationWrapper> relocations) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter(relocations, (String)"relocations");
            super(589824, parent);
            this.relocations = relocations;
        }

        @Override
        @NotNull
        public MethodVisitor visitMethod(int access, @Nullable String name2, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor methodVisitor = super.visitMethod(access, name2, descriptor, signature, exceptions);
            return new MethodVisitor(this, methodVisitor){
                final /* synthetic */ ConstantRelocatingClassVisitor this$0;
                {
                    this.this$0 = $receiver;
                    super(589824, $super_call_param$1);
                }

                public void visitLdcInsn(Object value2) {
                    if (value2 instanceof String) {
                        String v = (String)value2;
                        for (RelocationWrapper relocation : ConstantRelocatingClassVisitor.access$getRelocations$p(this.this$0)) {
                            if (StringsKt.startsWith$default((String)v, (String)relocation.getFromDot(), (boolean)false, (int)2, null)) {
                                v = StringsKt.replace$default((String)v, (String)relocation.getFromDot(), (String)relocation.getToDot(), (boolean)false, (int)4, null);
                                continue;
                            }
                            if (!StringsKt.startsWith$default((String)v, (String)relocation.getFromSlash(), (boolean)false, (int)2, null)) continue;
                            v = StringsKt.replace$default((String)v, (String)relocation.getFromSlash(), (String)relocation.getToSlash(), (boolean)false, (int)4, null);
                        }
                        super.visitLdcInsn(v);
                    } else {
                        super.visitLdcInsn(value2);
                    }
                }
            };
        }

        public static final /* synthetic */ List access$getRelocations$p(ConstantRelocatingClassVisitor $this) {
            return $this.relocations;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lio/papermc/paperweight/tasks/RelocateClassNameConstants$RelocationInput;", "", "()V", "fromPackage", "Lorg/gradle/api/provider/Property;", "", "getFromPackage", "()Lorg/gradle/api/provider/Property;", "toPackage", "getToPackage", "paperweight-lib"})
    public static abstract class RelocationInput {
        @Input
        @NotNull
        public abstract Property<String> getFromPackage();

        @Input
        @NotNull
        public abstract Property<String> getToPackage();
    }
}

