/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lio/papermc/paperweight/tasks/UnpackSpigotBuildData;", "Lio/papermc/paperweight/tasks/BaseTask;", "()V", "atFile", "Lorg/gradle/api/file/RegularFileProperty;", "getAtFile", "()Lorg/gradle/api/file/RegularFileProperty;", "buildDataInfoFile", "getBuildDataInfoFile", "buildDataZip", "getBuildDataZip", "classMappings", "getClassMappings", "excludesFile", "getExcludesFile", "specialSource2Jar", "getSpecialSource2Jar", "specialSourceJar", "getSpecialSourceJar", "bukkitFileFrom", "Ljava/nio/file/Path;", "dir", "extension", "", "init", "", "run", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nUnpackSpigotBuildData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnpackSpigotBuildData.kt\nio/papermc/paperweight/tasks/UnpackSpigotBuildData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public abstract class UnpackSpigotBuildData
extends BaseTask {
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBuildDataZip();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getBuildDataInfoFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getExcludesFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getAtFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getClassMappings();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getSpecialSourceJar();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getSpecialSource2Jar();

    @Override
    public void init() {
        this.getBuildDataInfoFile().convention((Provider)UtilsKt.defaultOutput(this, "spigot-build-data-info", "json"));
        this.getExcludesFile().convention((Provider)UtilsKt.defaultOutput(this, "spigot-excludes", "exclude"));
        this.getAtFile().convention((Provider)UtilsKt.defaultOutput(this, "spigot-ats", "at"));
        this.getClassMappings().convention((Provider)UtilsKt.defaultOutput(this, "spigot-class-mapping", "csrg"));
        this.getSpecialSourceJar().convention((Provider)UtilsKt.defaultOutput(this, "special-source", "jar"));
        this.getSpecialSource2Jar().convention((Provider)UtilsKt.defaultOutput(this, "special-source-2", "jar"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void run() {
        Closeable closeable = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getBuildDataZip())));
        Throwable throwable = null;
        try {
            FileSystem it = (FileSystem)closeable;
            boolean bl = false;
            Path root = it.getPath("/", new String[0]);
            Path path = root.resolve("info.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"root.resolve(\"info.json\")");
            Path path2 = path;
            Path path3 = FileKt.createParentDirectories(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getBuildDataInfoFile())), new FileAttribute[0]);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path3, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
            Path mappings = root.resolve("mappings");
            Intrinsics.checkNotNullExpressionValue((Object)mappings, (String)"mappings");
            path3 = this.bukkitFileFrom(mappings, "exclude");
            Path path4 = FileKt.createParentDirectories(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getExcludesFile())), new FileAttribute[0]);
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray3 = copyOptionArray2;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path3, path4, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
            path3 = this.bukkitFileFrom(mappings, "at");
            path4 = FileKt.createParentDirectories(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getAtFile())), new FileAttribute[0]);
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            copyOptionArray3 = copyOptionArray2;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path3, path4, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
            path3 = this.bukkitFileFrom(mappings, "csrg");
            path4 = FileKt.createParentDirectories(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getClassMappings())), new FileAttribute[0]);
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            copyOptionArray3 = copyOptionArray2;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path3, path4, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
            Path path5 = root.resolve("bin/SpecialSource.jar");
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"root.resolve(\"bin/SpecialSource.jar\")");
            path3 = path5;
            path4 = FileKt.createParentDirectories(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getSpecialSourceJar())), new FileAttribute[0]);
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            copyOptionArray3 = copyOptionArray2;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path3, path4, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
            Path path6 = root.resolve("bin/SpecialSource-2.jar");
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"root.resolve(\"bin/SpecialSource-2.jar\")");
            path3 = path6;
            path4 = FileKt.createParentDirectories(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getSpecialSource2Jar())), new FileAttribute[0]);
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            copyOptionArray3 = copyOptionArray2;
            Path path7 = Files.copy(path3, path4, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length));
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"copy(...)");
            Path path8 = path7;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path bukkitFileFrom(Path dir2, String extension) {
        Iterable iterable;
        Path path = dir2;
        Closeable closeable = Files.newDirectoryStream(path, "*");
        Throwable throwable = null;
        try {
            iterable = (DirectoryStream)closeable;
            Intrinsics.checkNotNull((Object)iterable);
            Sequence it = CollectionsKt.asSequence((Iterable)iterable);
            boolean bl = false;
            iterable = (Path)SequencesKt.single((Sequence)SequencesKt.filter((Sequence)it, (Function1)((Function1)new Function1<Path, Boolean>(extension){
                final /* synthetic */ String $extension;
                {
                    this.$extension = $extension;
                    super(1);
                }

                public final Boolean invoke(Path f) {
                    Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                    return StringsKt.endsWith$default((String)PathsKt.getName((Path)f), (String)this.$extension, (boolean)false, (int)2, null);
                }
            })));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return iterable;
    }
}

