/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.action;

import io.papermc.paperweight.userdev.internal.action.WorkGraph;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.File_lockKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.reflect.TypeToken;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/papermc/paperweight/userdev/internal/action/CacheManager;", "", "root", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "cleanup", "", "deleteUnusedAfter", "", "performMaintenance", "", "expireUnusedAfter", "performCleanupAfter", "delayCleanupBy", "bundleZipHash", "", "Companion", "MaintenanceInfo", "paperweight-userdev"})
@SourceDebugExtension(value={"SMAP\nCacheManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheManager.kt\nio/papermc/paperweight/userdev/internal/action/CacheManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 utils.kt\nio/papermc/paperweight/util/UtilsKt\n+ 4 Gson.kt\ncom/github/salomonbrys/kotson/GsonKt\n+ 5 GsonBuilder.kt\ncom/github/salomonbrys/kotson/GsonBuilderKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1863#2,2:153\n1863#2:155\n1864#2:174\n1863#2,2:175\n97#3,2:156\n99#3:165\n100#3:173\n17#4:158\n19#4:167\n61#5:159\n13#5:160\n63#5,4:161\n13#5:168\n63#5,4:169\n1#6:166\n*S KotlinDebug\n*F\n+ 1 CacheManager.kt\nio/papermc/paperweight/userdev/internal/action/CacheManager\n*L\n107#1:153,2\n127#1:155\n127#1:174\n134#1:175,2\n129#1:156,2\n129#1:165\n129#1:173\n129#1:158\n129#1:167\n129#1:159\n129#1:160\n129#1:161,4\n129#1:168\n129#1:169,4\n129#1:166\n*E\n"})
public final class CacheManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path root;
    private static final Logger logger = Logging.getLogger(CacheManager.class);

    public CacheManager(@NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    public final void performMaintenance(long expireUnusedAfter, long performCleanupAfter, long delayCleanupBy, @NotNull String bundleZipHash) {
        Intrinsics.checkNotNullParameter((Object)bundleZipHash, (String)"bundleZipHash");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(this.root, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        Path maintenanceLock = this.root.resolve("maintenance.lock");
        Path maintenanceFile = this.root.resolve("maintenance.json");
        long start = System.nanoTime();
        Intrinsics.checkNotNullExpressionValue((Object)maintenanceLock, (String)"maintenanceLock");
        File_lockKt.withLock$default(maintenanceLock, 0L, 0L, (Function0)new Function0<Unit>(start, this, maintenanceFile, performCleanupAfter, delayCleanupBy, expireUnusedAfter, bundleZipHash){
            final /* synthetic */ long $start;
            final /* synthetic */ CacheManager this$0;
            final /* synthetic */ Path $maintenanceFile;
            final /* synthetic */ long $performCleanupAfter;
            final /* synthetic */ long $delayCleanupBy;
            final /* synthetic */ long $expireUnusedAfter;
            final /* synthetic */ String $bundleZipHash;
            {
                this.$start = $start;
                this.this$0 = $receiver;
                this.$maintenanceFile = $maintenanceFile;
                this.$performCleanupAfter = $performCleanupAfter;
                this.$delayCleanupBy = $delayCleanupBy;
                this.$expireUnusedAfter = $expireUnusedAfter;
                this.$bundleZipHash = $bundleZipHash;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                Path $this$forEach$iv;
                CacheManager.access$getLogger$cp().info("paperweight-userdev: Acquired cache maintenance lock in " + io.papermc.paperweight.userdev.internal.util.UtilsKt.formatNs(System.nanoTime() - this.$start));
                Iterable iterable = PathsKt.listDirectoryEntries$default((Path)CacheManager.access$getRoot$p(this.this$0), null, (int)1, null);
                LinkOption[] linkOptionArray = this.$bundleZipHash;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Object object;
                    Gson gson;
                    Path entry = (Path)element$iv;
                    boolean bl = false;
                    Path metadataFile = entry.resolve("metadata.json");
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    if (!Files.isDirectory(entry, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)metadataFile, (String)"metadataFile");
                    LinkOption[] linkOptionArray3 = new LinkOption[]{};
                    if (!Files.isRegularFile(metadataFile, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)entry.resolve("lock"), (String)"entry.resolve(\"lock\")");
                    LinkOption[] linkOptionArray4 = new LinkOption[0];
                    if (Files.exists((Path)((Object)gson), Arrays.copyOf(linkOptionArray4, linkOptionArray4.length)) || !StringsKt.endsWith$default((String)PathsKt.getName((Path)entry), (String)("_" + (String)linkOptionArray), (boolean)false, (int)2, null)) continue;
                    gson = UtilsKt.getGson();
                    Path any$iv = metadataFile;
                    boolean $i$f$fromJson = false;
                    if (any$iv instanceof String) {
                        Type type;
                        Type type$iv$iv$iv;
                        void $receiver$iv$iv;
                        String json$iv$iv;
                        var12_13 = $this$fromJson$iv;
                        var14_15 = json$iv$iv = (String)((Object)any$iv);
                        var15_19 = $receiver$iv$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)new TypeToken<WorkGraph.Metadata>(){}.getType(), (String)"object : TypeToken<T>() {} .type");
                        if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                            Type type2 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                            type = type2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"type.rawType");
                        } else {
                            type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv);
                        }
                        var17_22 = type;
                        T t = var15_19.fromJson(var14_15, (Type)var17_22);
                        object = t;
                        Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
                    } else {
                        var12_13 = UtilsKt.convertToPath(any$iv);
                        Object object2 = Charsets.UTF_8;
                        var15_19 = new OpenOption[]{};
                        int n = 8192;
                        var12_13 = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)var12_13, Arrays.copyOf(var15_19, var15_19.length)), (Charset)object2), n);
                        object2 = null;
                        try {
                            Type type;
                            Type type$iv$iv$iv;
                            BufferedReader it$iv = (BufferedReader)var12_13;
                            boolean bl2 = false;
                            void $receiver$iv$iv = $this$fromJson$iv;
                            var17_22 = it$iv;
                            void var18_23 = $receiver$iv$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)new TypeToken<WorkGraph.Metadata>(){}.getType(), (String)"object : TypeToken<T>() {} .type");
                            if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                                Type type3 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                                type = type3;
                                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
                            } else {
                                type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv);
                            }
                            Type type4 = type;
                            Intrinsics.checkExpressionValueIsNotNull(var18_23.fromJson((Reader)var17_22, type4), (String)"fromJson(json, typeToken<T>())");
                            object = var14_15;
                        }
                        catch (Throwable throwable) {
                            object2 = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var12_13, (Throwable)object2);
                        }
                    }
                    ((WorkGraph.Metadata)object).updateLastUsed().writeTo(metadataFile);
                }
                Path path = this.$maintenanceFile;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"maintenanceFile");
                $this$forEach$iv = path;
                linkOptionArray = new LinkOption[]{};
                if (Files.isRegularFile($this$forEach$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    Path path2 = this.$maintenanceFile;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"maintenanceFile");
                    MaintenanceInfo info = MaintenanceInfo.Companion.readFrom(path2);
                    if (System.currentTimeMillis() - info.getLastCleanup() < this.$performCleanupAfter) {
                        return;
                    }
                    if (info.getScheduledCleanup() == null) {
                        long cleanup2 = System.currentTimeMillis() + this.$delayCleanupBy;
                        CacheManager.access$getLogger$cp().info("paperweight-userdev: Scheduled cache cleanup for after " + Instant.ofEpochMilli(cleanup2));
                        MaintenanceInfo maintenanceInfo = MaintenanceInfo.copy$default(info, 0L, cleanup2, 1, null);
                        Path path3 = this.$maintenanceFile;
                        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"maintenanceFile");
                        maintenanceInfo.writeTo(path3);
                    } else if (System.currentTimeMillis() >= info.getScheduledCleanup() && CacheManager.access$cleanup(this.this$0, this.$expireUnusedAfter)) {
                        MaintenanceInfo maintenanceInfo = info.copy(System.currentTimeMillis(), null);
                        Path path4 = this.$maintenanceFile;
                        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"maintenanceFile");
                        maintenanceInfo.writeTo(path4);
                    }
                } else {
                    MaintenanceInfo maintenanceInfo = new MaintenanceInfo(0L, null, 3, null);
                    Path path5 = this.$maintenanceFile;
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"maintenanceFile");
                    maintenanceInfo.writeTo(path5);
                }
            }
        }, 6, null);
        logger.info("paperweight-userdev: Finished cache maintenance in " + io.papermc.paperweight.userdev.internal.util.UtilsKt.formatNs(System.nanoTime() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean cleanup(long deleteUnusedAfter) {
        List tryDelete = new ArrayList();
        List keep = new ArrayList();
        Iterable $this$forEach$iv = PathsKt.listDirectoryEntries$default((Path)this.root, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path;
            Path it = (Path)element$iv;
            boolean bl = false;
            Path metadataFile = it.resolve("metadata.json");
            Intrinsics.checkNotNullExpressionValue((Object)metadataFile, (String)"metadataFile");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(metadataFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it.resolve("lock"), (String)"it.resolve(\"lock\")");
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                logger.info("paperweight-userdev: Aborted cache cleanup due to locked cache entry (" + PathsKt.getName((Path)it) + ")");
                return false;
            }
            long l = System.currentTimeMillis();
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            FileTime fileTime = Files.getLastModifiedTime(metadataFile, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length));
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
            long since = l - fileTime.toMillis();
            if (since > deleteUnusedAfter) {
                tryDelete.add(it);
                continue;
            }
            keep.add(it);
        }
        int deleted = 0;
        Ref.LongRef deletedSize = new Ref.LongRef();
        if (!((Collection)tryDelete).isEmpty()) {
            Iterable $this$forEach$iv2 = keep;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Set<String> it;
                Object object;
                Path k = (Path)element$iv;
                boolean bl = false;
                Path metadataFile = k.resolve("metadata.json");
                Gson since = UtilsKt.getGson();
                Intrinsics.checkNotNullExpressionValue((Object)metadataFile, (String)"metadataFile");
                Path any$iv = metadataFile;
                boolean $i$f$fromJson = false;
                if (any$iv instanceof String) {
                    Type type;
                    Type type$iv$iv$iv;
                    void $receiver$iv$iv;
                    String json$iv$iv;
                    var17_24 = $this$fromJson$iv;
                    var19_26 = json$iv$iv = (String)((Object)any$iv);
                    var20_30 = $receiver$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)new TypeToken<WorkGraph.Metadata>(){}.getType(), (String)"object : TypeToken<T>() {} .type");
                    if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                        Type type2 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                        type = type2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"type.rawType");
                    } else {
                        type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv);
                    }
                    var22_33 = type;
                    Object t = var20_30.fromJson(var19_26, (Type)var22_33);
                    object = t;
                    Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
                } else {
                    var17_24 = UtilsKt.convertToPath(any$iv);
                    Object object2 = Charsets.UTF_8;
                    var20_30 = new OpenOption[]{};
                    int n = 8192;
                    var17_24 = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)var17_24, Arrays.copyOf(var20_30, var20_30.length)), (Charset)object2), n);
                    object2 = null;
                    try {
                        Type type;
                        Type type$iv$iv$iv;
                        BufferedReader it$iv = (BufferedReader)var17_24;
                        boolean bl2 = false;
                        void $receiver$iv$iv = $this$fromJson$iv;
                        var22_33 = it$iv;
                        void var23_34 = $receiver$iv$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)new TypeToken<WorkGraph.Metadata>(){}.getType(), (String)"object : TypeToken<T>() {} .type");
                        if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                            Type type3 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                            type = type3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
                        } else {
                            type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv);
                        }
                        Type type4 = type;
                        Intrinsics.checkExpressionValueIsNotNull(var23_34.fromJson((Reader)var22_33, type4), (String)"fromJson(json, typeToken<T>())");
                        object = var19_26;
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var17_24, (Throwable)object2);
                    }
                }
                if (((WorkGraph.Metadata)object).getSkippedWhenUpToDate() == null) continue;
                boolean bl3 = false;
                tryDelete.removeIf(new Predicate(it){
                    final /* synthetic */ Set<String> $it;
                    {
                        this.$it = $it;
                    }

                    public final boolean test(Path o) {
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        return this.$it.contains(PathsKt.getName((Path)o));
                    }
                });
            }
            $this$forEach$iv2 = tryDelete;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Path it = (Path)element$iv;
                boolean bl = false;
                ++deleted;
                FileKt.deleteRecursive$default(it, null, (Function1)new Function1<Path, Unit>(deletedSize){
                    final /* synthetic */ Ref.LongRef $deletedSize;
                    {
                        this.$deletedSize = $deletedSize;
                        super(1);
                    }

                    public final void invoke(Path toDelete2) {
                        Intrinsics.checkNotNullParameter((Object)toDelete2, (String)"toDelete");
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (Files.isRegularFile(toDelete2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            this.$deletedSize.element += Files.size(toDelete2);
                        }
                    }
                }, 1, null);
            }
        }
        LogLevel level = deleted > 0 ? LogLevel.LIFECYCLE : LogLevel.INFO;
        logger.log(level, "paperweight-userdev: Deleted " + deleted + " expired cache entries totaling " + deletedSize.element / (long)1024 + "KB");
        return true;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Path access$getRoot$p(CacheManager $this) {
        return $this.root;
    }

    public static final /* synthetic */ boolean access$cleanup(CacheManager $this, long deleteUnusedAfter) {
        return $this.cleanup(deleteUnusedAfter);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/papermc/paperweight/userdev/internal/action/CacheManager$Companion;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "paperweight-userdev"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ$\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lio/papermc/paperweight/userdev/internal/action/CacheManager$MaintenanceInfo;", "", "lastCleanup", "", "scheduledCleanup", "(JLjava/lang/Long;)V", "getLastCleanup", "()J", "getScheduledCleanup", "()Ljava/lang/Long;", "Ljava/lang/Long;", "component1", "component2", "copy", "(JLjava/lang/Long;)Lio/papermc/paperweight/userdev/internal/action/CacheManager$MaintenanceInfo;", "equals", "", "other", "hashCode", "", "toString", "", "writeTo", "", "file", "Ljava/nio/file/Path;", "Companion", "paperweight-userdev"})
    public static final class MaintenanceInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long lastCleanup;
        @Nullable
        private final Long scheduledCleanup;

        public MaintenanceInfo(long lastCleanup, @Nullable Long scheduledCleanup) {
            this.lastCleanup = lastCleanup;
            this.scheduledCleanup = scheduledCleanup;
        }

        public /* synthetic */ MaintenanceInfo(long l, Long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = System.currentTimeMillis();
            }
            if ((n & 2) != 0) {
                l2 = null;
            }
            this(l, l2);
        }

        public final long getLastCleanup() {
            return this.lastCleanup;
        }

        @Nullable
        public final Long getScheduledCleanup() {
            return this.scheduledCleanup;
        }

        public final void writeTo(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Path path = FileKt.createParentDirectories(file2, new FileAttribute[0]);
            String string = UtilsKt.getGson().toJson(this);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(this)");
            PathsKt.writeText$default((Path)path, (CharSequence)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
        }

        public final long component1() {
            return this.lastCleanup;
        }

        @Nullable
        public final Long component2() {
            return this.scheduledCleanup;
        }

        @NotNull
        public final MaintenanceInfo copy(long lastCleanup, @Nullable Long scheduledCleanup) {
            return new MaintenanceInfo(lastCleanup, scheduledCleanup);
        }

        public static /* synthetic */ MaintenanceInfo copy$default(MaintenanceInfo maintenanceInfo, long l, Long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = maintenanceInfo.lastCleanup;
            }
            if ((n & 2) != 0) {
                l2 = maintenanceInfo.scheduledCleanup;
            }
            return maintenanceInfo.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "MaintenanceInfo(lastCleanup=" + this.lastCleanup + ", scheduledCleanup=" + this.scheduledCleanup + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.lastCleanup);
            result2 = result2 * 31 + (this.scheduledCleanup == null ? 0 : ((Object)this.scheduledCleanup).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MaintenanceInfo)) {
                return false;
            }
            MaintenanceInfo maintenanceInfo = (MaintenanceInfo)other;
            if (this.lastCleanup != maintenanceInfo.lastCleanup) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.scheduledCleanup, (Object)maintenanceInfo.scheduledCleanup);
        }

        public MaintenanceInfo() {
            this(0L, null, 3, null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/papermc/paperweight/userdev/internal/action/CacheManager$MaintenanceInfo$Companion;", "", "()V", "readFrom", "Lio/papermc/paperweight/userdev/internal/action/CacheManager$MaintenanceInfo;", "file", "Ljava/nio/file/Path;", "paperweight-userdev"})
        @SourceDebugExtension(value={"SMAP\nCacheManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheManager.kt\nio/papermc/paperweight/userdev/internal/action/CacheManager$MaintenanceInfo$Companion\n+ 2 utils.kt\nio/papermc/paperweight/util/UtilsKt\n+ 3 Gson.kt\ncom/github/salomonbrys/kotson/GsonKt\n+ 4 GsonBuilder.kt\ncom/github/salomonbrys/kotson/GsonBuilderKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n97#2,2:153\n99#2:162\n100#2:170\n17#3:155\n19#3:164\n61#4:156\n13#4:157\n63#4,4:158\n13#4:165\n63#4,4:166\n1#5:163\n*S KotlinDebug\n*F\n+ 1 CacheManager.kt\nio/papermc/paperweight/userdev/internal/action/CacheManager$MaintenanceInfo$Companion\n*L\n48#1:153,2\n48#1:162\n48#1:170\n48#1:155\n48#1:164\n48#1:156\n48#1:157\n48#1:158,4\n48#1:165\n48#1:166,4\n48#1:163\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final MaintenanceInfo readFrom(@NotNull Path file2) {
                Object t;
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Gson $this$fromJson$iv = UtilsKt.getGson();
                boolean $i$f$fromJson = false;
                if (file2 instanceof String) {
                    Type type;
                    void $receiver$iv$iv;
                    String json$iv$iv;
                    Gson gson = $this$fromJson$iv;
                    String string = json$iv$iv = (String)((Object)file2);
                    void var7_13 = $receiver$iv$iv;
                    Type type2 = new TypeToken<MaintenanceInfo>(){}.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
                    Type type$iv$iv$iv = type2;
                    if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                        Type type3 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                        type = type3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
                    } else {
                        type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv);
                    }
                    Type type4 = type;
                    Object t2 = var7_13.fromJson(string, type4);
                    t = t2;
                    Intrinsics.checkExpressionValueIsNotNull(t2, (String)"fromJson(json, typeToken<T>())");
                } else {
                    Object object = UtilsKt.convertToPath(file2);
                    Object object2 = Charsets.UTF_8;
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    int n = 8192;
                    object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
                    object2 = null;
                    try {
                        Type type;
                        BufferedReader it$iv = (BufferedReader)object;
                        boolean bl = false;
                        Gson $receiver$iv$iv = $this$fromJson$iv;
                        Reader reader = it$iv;
                        Gson gson = $receiver$iv$iv;
                        Type type5 = new TypeToken<MaintenanceInfo>(){}.getType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"object : TypeToken<T>() {} .type");
                        Type type$iv$iv$iv = type5;
                        if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                            Type type6 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                            type = type6;
                            Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"type.rawType");
                        } else {
                            type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv);
                        }
                        Type type7 = type;
                        Object t3 = gson.fromJson(reader, type7);
                        Intrinsics.checkExpressionValueIsNotNull(t3, (String)"fromJson(json, typeToken<T>())");
                        Object t4 = t3;
                        t = t4;
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                    }
                }
                return (MaintenanceInfo)t;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

