/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup.action;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.mache.DecompileJarKt;
import io.papermc.paperweight.userdev.internal.action.DirectoryValue;
import io.papermc.paperweight.userdev.internal.action.FileCollectionValue;
import io.papermc.paperweight.userdev.internal.action.FileValue;
import io.papermc.paperweight.userdev.internal.action.Input;
import io.papermc.paperweight.userdev.internal.action.ListValue;
import io.papermc.paperweight.userdev.internal.action.Output;
import io.papermc.paperweight.userdev.internal.action.Value;
import io.papermc.paperweight.userdev.internal.action.WorkDispatcher;
import io.papermc.paperweight.userdev.internal.util.UtilsKt;
import java.io.Closeable;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.jvm.toolchain.JavaLauncher;
import paper.libs.codechicken.diffpatch.cli.CliOperation;
import paper.libs.codechicken.diffpatch.cli.PatchOperation;
import paper.libs.codechicken.diffpatch.util.LogLevel;
import paper.libs.codechicken.diffpatch.util.archiver.ArchiveFormat;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001BI\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\b\u0010 \u001a\u00020!H\u0016R\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0018\u0010\u0012R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0019\u0010\u0012R\u001c\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0012\u001a\u0004\b\u001b\u0010\u0017R\u0016\u0010\b\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001c\u0010\u0012R\u001c\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0012\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Lio/papermc/paperweight/userdev/internal/setup/action/SetupMacheSourcesAction;", "Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher$Action;", "javaLauncher", "Lio/papermc/paperweight/userdev/internal/action/Value;", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "inputJar", "Lio/papermc/paperweight/userdev/internal/action/FileValue;", "outputJar", "minecraftLibraryJars", "Lio/papermc/paperweight/userdev/internal/action/DirectoryValue;", "decompileArgs", "Lio/papermc/paperweight/userdev/internal/action/ListValue;", "", "decompiler", "Lio/papermc/paperweight/userdev/internal/action/FileCollectionValue;", "mache", "(Lio/papermc/paperweight/userdev/internal/action/Value;Lio/papermc/paperweight/userdev/internal/action/FileValue;Lio/papermc/paperweight/userdev/internal/action/FileValue;Lio/papermc/paperweight/userdev/internal/action/DirectoryValue;Lio/papermc/paperweight/userdev/internal/action/ListValue;Lio/papermc/paperweight/userdev/internal/action/FileCollectionValue;Lio/papermc/paperweight/userdev/internal/action/FileCollectionValue;)V", "getDecompileArgs$annotations", "()V", "getDecompileArgs", "()Lio/papermc/paperweight/userdev/internal/action/ListValue;", "getDecompiler$annotations", "getDecompiler", "()Lio/papermc/paperweight/userdev/internal/action/FileCollectionValue;", "getInputJar$annotations", "getJavaLauncher$annotations", "getMache$annotations", "getMache", "getMinecraftLibraryJars$annotations", "getOutputJar$annotations", "getOutputJar", "()Lio/papermc/paperweight/userdev/internal/action/FileValue;", "execute", "", "paperweight-userdev"})
public final class SetupMacheSourcesAction
implements WorkDispatcher.Action {
    @NotNull
    private final Value<JavaLauncher> javaLauncher;
    @NotNull
    private final FileValue inputJar;
    @NotNull
    private final FileValue outputJar;
    @NotNull
    private final DirectoryValue minecraftLibraryJars;
    @NotNull
    private final ListValue<String> decompileArgs;
    @NotNull
    private final FileCollectionValue decompiler;
    @NotNull
    private final FileCollectionValue mache;

    public SetupMacheSourcesAction(@NotNull Value<JavaLauncher> javaLauncher, @NotNull FileValue inputJar, @NotNull FileValue outputJar, @NotNull DirectoryValue minecraftLibraryJars, @NotNull ListValue<String> decompileArgs, @NotNull FileCollectionValue decompiler, @NotNull FileCollectionValue mache) {
        Intrinsics.checkNotNullParameter(javaLauncher, (String)"javaLauncher");
        Intrinsics.checkNotNullParameter((Object)inputJar, (String)"inputJar");
        Intrinsics.checkNotNullParameter((Object)outputJar, (String)"outputJar");
        Intrinsics.checkNotNullParameter((Object)minecraftLibraryJars, (String)"minecraftLibraryJars");
        Intrinsics.checkNotNullParameter(decompileArgs, (String)"decompileArgs");
        Intrinsics.checkNotNullParameter((Object)decompiler, (String)"decompiler");
        Intrinsics.checkNotNullParameter((Object)mache, (String)"mache");
        this.javaLauncher = javaLauncher;
        this.inputJar = inputJar;
        this.outputJar = outputJar;
        this.minecraftLibraryJars = minecraftLibraryJars;
        this.decompileArgs = decompileArgs;
        this.decompiler = decompiler;
        this.mache = mache;
    }

    @Input
    private static /* synthetic */ void getJavaLauncher$annotations() {
    }

    @Input
    private static /* synthetic */ void getInputJar$annotations() {
    }

    @NotNull
    public final FileValue getOutputJar() {
        return this.outputJar;
    }

    @Output
    public static /* synthetic */ void getOutputJar$annotations() {
    }

    @Input
    private static /* synthetic */ void getMinecraftLibraryJars$annotations() {
    }

    @NotNull
    public final ListValue<String> getDecompileArgs() {
        return this.decompileArgs;
    }

    @Input
    public static /* synthetic */ void getDecompileArgs$annotations() {
    }

    @NotNull
    public final FileCollectionValue getDecompiler() {
        return this.decompiler;
    }

    @Input
    public static /* synthetic */ void getDecompiler$annotations() {
    }

    @NotNull
    public final FileCollectionValue getMache() {
        return this.mache;
    }

    @Input
    public static /* synthetic */ void getMache$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        CliOperation.Result<PatchOperation.PatchesSummary> result2;
        Path path = ((Path)this.outputJar.get()).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputJar.get().parent");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
        Path tmpDir = path3;
        Path tempOut = ((Path)this.outputJar.get()).resolveSibling("decompile.jar");
        Intrinsics.checkNotNullExpressionValue((Object)tempOut, (String)"tempOut");
        DecompileJarKt.macheDecompileJar$default(tempOut, UtilsKt.jars((Path)this.minecraftLibraryJars.get()), (List)this.decompileArgs.get(), (Path)this.inputJar.get(), this.javaLauncher.get(), this.decompiler.get(), tmpDir, null, 128, null);
        io.papermc.paperweight.util.UtilsKt.cleanFile((Path)this.outputJar.get());
        Path log = tmpDir.resolve(PathsKt.getName((Path)((Path)this.outputJar.get())) + ".log");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)log, (String)"log");
        objectArray[0] = log;
        io.papermc.paperweight.util.UtilsKt.ensureDeleted(objectArray);
        Closeable closeable = new PrintStream(log.toFile(), Charsets.UTF_8);
        Throwable throwable = null;
        try {
            PrintStream logOut = (PrintStream)closeable;
            boolean bl = false;
            result2 = PatchOperation.builder().logTo(logOut).basePath(tempOut, ArchiveFormat.ZIP).outputPath((Path)this.outputJar.get(), ArchiveFormat.ZIP).patchesPath(this.mache.get().getSingleFile().toPath(), ArchiveFormat.ZIP).patchesPrefix("patches").level(LogLevel.ALL).summary(true).build().operate();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        CliOperation.Result<PatchOperation.PatchesSummary> result3 = result2;
        io.papermc.paperweight.util.UtilsKt.cleanFile(tempOut);
        if (result3.exit != 0) {
            throw new PaperweightException("Failed to apply mache patches. See the log file at '" + log.toFile() + "' for more details.");
        }
    }
}

