/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.util;

import io.papermc.paperweight.userdev.internal.util.UtilsKt;
import io.papermc.paperweight.util.FileKt;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Provider;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00012\u0006\u0010\r\u001a\u00020\u0003\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00012\u0006\u0010\r\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u001a\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00012\u0006\u0010\r\u001a\u00020\u0003\u001a\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0011\u001a\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00012\u0006\u0010\r\u001a\u00020\u0003\u001a\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u0001*\b\u0012\u0004\u0012\u00020\u00140\u0001H\u0002\u001a\u0010\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d*\u00020\u000f\u001a\n\u0010\u001e\u001a\u00020\u000f*\u00020\u000f\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0002*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0002*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001f\u00b2\u0006\n\u0010 \u001a\u00020\u0011X\u008a\u0084\u0002"}, d2={"ci", "Lorg/gradle/api/provider/Provider;", "", "Lorg/gradle/api/Project;", "getCi", "(Lorg/gradle/api/Project;)Lorg/gradle/api/provider/Provider;", "genSources", "getGenSources", "(Lorg/gradle/api/Project;)Z", "sharedCaches", "getSharedCaches", "cleanSharedCaches", "", "target", "root", "Ljava/nio/file/Path;", "delayCleanupBy", "", "deleteUnusedAfter", "experimentalProp", "", "name", "expireUnusedAfter", "formatNs", "ns", "performCleanupAfter", "stableProp", "durationMillis", "jars", "", "siblingLogFile", "paperweight-userdev", "cutoff"})
public final class UtilsKt {
    @NotNull
    public static final String formatNs(long ns) {
        long ms = ns / (long)1000000;
        if (ms < 1000L) {
            return ms + "ms";
        }
        long s = ms / (long)1000;
        long rem = ms % (long)1000;
        if (s < 60L) {
            return s + "." + StringsKt.padStart((String)String.valueOf(rem), (int)3, (char)'0') + "s";
        }
        long m = s / (long)60;
        long remS = s % (long)60 + Math.round((double)rem / 1000.0);
        return m + "m " + remS + "s";
    }

    @NotNull
    public static final Path siblingLogFile(@NotNull Path $this$siblingLogFile) {
        Intrinsics.checkNotNullParameter((Object)$this$siblingLogFile, (String)"<this>");
        return FileKt.withDifferentExtension($this$siblingLogFile, "log");
    }

    @NotNull
    public static final List<Path> jars(@NotNull Path $this$jars) {
        Intrinsics.checkNotNullParameter((Object)$this$jars, (String)"<this>");
        return FileKt.filesMatchingRecursive($this$jars, "*.jar");
    }

    @NotNull
    public static final Provider<Boolean> getCi(@NotNull Project $this$ci) {
        Intrinsics.checkNotNullParameter((Object)$this$ci, (String)"<this>");
        Provider provider = $this$ci.getProviders().environmentVariable("CI").map((Transformer)ci.1.INSTANCE).orElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providers.environmentVar\u2026 }\n        .orElse(false)");
        return provider;
    }

    private static final String stableProp(String name2) {
        return "paperweight." + name2;
    }

    private static final String experimentalProp(String name2) {
        return "paperweight.experimental." + name2;
    }

    public static final boolean getGenSources(@NotNull Project $this$genSources) {
        Boolean prop;
        Intrinsics.checkNotNullParameter((Object)$this$genSources, (String)"<this>");
        Object object = UtilsKt.getCi($this$genSources).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ci.get()");
        boolean ci2 = (Boolean)object;
        String string = (String)$this$genSources.getProviders().gradleProperty(UtilsKt.experimentalProp("genSources")).getOrNull();
        Boolean bl = prop = string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
        return bl != null ? bl : !ci2;
    }

    public static final boolean getSharedCaches(@NotNull Project $this$sharedCaches) {
        Intrinsics.checkNotNullParameter((Object)$this$sharedCaches, (String)"<this>");
        Object object = $this$sharedCaches.getProviders().gradleProperty(UtilsKt.stableProp("sharedCaches")).map((Transformer)sharedCaches.1.INSTANCE).orElse((Object)true).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"providers.gradleProperty\u2026Else(true)\n        .get()");
        return (Boolean)object;
    }

    private static final Provider<Long> durationMillis(Provider<String> $this$durationMillis) {
        Provider provider = $this$durationMillis.map((Transformer)durationMillis.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"map { value -> parseDuration(value).toMillis() }");
        return provider;
    }

    @NotNull
    public static final Provider<Long> expireUnusedAfter(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Provider provider = target.getProviders().gradleProperty(UtilsKt.experimentalProp("caches.expireUnusedAfter"));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"target.providers.gradleP\u2026ches.expireUnusedAfter\"))");
        Provider provider2 = UtilsKt.durationMillis((Provider<String>)provider).orElse(UtilsKt.deleteUnusedAfter(target));
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"target.providers.gradleP\u2026eleteUnusedAfter(target))");
        return provider2;
    }

    @NotNull
    public static final Provider<Long> performCleanupAfter(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Provider provider = target.getProviders().gradleProperty(UtilsKt.experimentalProp("caches.performCleanupAfter"));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"target.providers.gradleP\u2026es.performCleanupAfter\"))");
        Provider provider2 = UtilsKt.durationMillis((Provider<String>)provider).orElse(UtilsKt.expireUnusedAfter(target));
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"target.providers.gradleP\u2026xpireUnusedAfter(target))");
        return provider2;
    }

    @NotNull
    public static final Provider<Long> delayCleanupBy(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Provider provider = target.getProviders().gradleProperty(UtilsKt.experimentalProp("caches.delayCleanupBy"));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"target.providers.gradleP\u2026\"caches.delayCleanupBy\"))");
        Provider provider2 = UtilsKt.durationMillis((Provider<String>)provider).orElse((Object)Duration.ofHours(12L).toMillis());
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"target.providers.gradleP\u2026n.ofHours(12).toMillis())");
        return provider2;
    }

    private static final Provider<Long> deleteUnusedAfter(Project target) {
        Provider provider = target.getProviders().gradleProperty(UtilsKt.stableProp("sharedCaches.deleteUnusedAfter"));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"target.providers.gradleP\u2026ches.deleteUnusedAfter\"))");
        Provider provider2 = UtilsKt.durationMillis((Provider<String>)provider).orElse((Object)Duration.ofDays(7L).toMillis());
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"target.providers.gradleP\u2026ion.ofDays(7).toMillis())");
        return provider2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void cleanSharedCaches(@NotNull Project target, @NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(root, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        Object object = Files.walk(root, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Object stream = (Stream)object;
            boolean bl = false;
            Lazy cutoff$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(target){
                final /* synthetic */ Project $target;
                {
                    this.$target = $target;
                    super(0);
                }

                public final Long invoke() {
                    Object object = UtilsKt.access$deleteUnusedAfter(this.$target).get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deleteUnusedAfter(target).get()");
                    return (Long)object;
                }
            }));
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
            stream = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)cleanSharedCaches.toDelete.1.1.INSTANCE), (Function1)((Function1)new Function1<Path, Path>((Lazy<Long>)cutoff$delegate){
                final /* synthetic */ Lazy<Long> $cutoff$delegate;
                {
                    this.$cutoff$delegate = $cutoff$delegate;
                    super(1);
                }

                public final Path invoke(Path it) {
                    Path pwDir = it.getParent().getParent();
                    Path cacheDir = pwDir.getParent();
                    Path lock2 = cacheDir.resolve("paperweight/lock/userdev/setup.lock");
                    Intrinsics.checkNotNullExpressionValue((Object)lock2, (String)"lock");
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(lock2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && ProcessHandle.of(Long.parseLong(PathsKt.readText$default((Path)lock2, null, (int)1, null))).isPresent()) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    long lastUsed = Long.parseLong(PathsKt.readText$default((Path)it, null, (int)1, null));
                    long since = System.currentTimeMillis() - lastUsed;
                    return since > UtilsKt.access$cleanSharedCaches$lambda$1$lambda$0(this.$cutoff$delegate) ? pwDir : null;
                }
            })));
        }
        catch (Throwable stream) {
            throwable = stream;
            throw stream;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object toDelete2 = stream;
        object = toDelete2.iterator();
        while (object.hasNext()) {
            Path parent;
            List entries;
            Path path = (Path)object.next();
            FileKt.deleteRecursive$default(path, null, null, 3, null);
            Intrinsics.checkNotNullExpressionValue((Object)path.getParent(), (String)"path.parent");
            while ((entries = PathsKt.listDirectoryEntries$default((Path)parent, null, (int)1, null)).isEmpty()) {
                Files.deleteIfExists(parent);
                Intrinsics.checkNotNullExpressionValue((Object)parent.getParent(), (String)"parent.parent");
            }
        }
    }

    private static final long cleanSharedCaches$lambda$1$lambda$0(Lazy<Long> $cutoff$delegate) {
        Lazy<Long> lazy = $cutoff$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public static final /* synthetic */ Provider access$deleteUnusedAfter(Project target) {
        return UtilsKt.deleteUnusedAfter(target);
    }

    public static final /* synthetic */ long access$cleanSharedCaches$lambda$1$lambda$0(Lazy $cutoff$delegate) {
        return UtilsKt.cleanSharedCaches$lambda$1$lambda$0((Lazy<Long>)$cutoff$delegate);
    }
}

