/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.FileSystemReference;
import io.papermc.paperweight.util.NioKt;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathWalkOption;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J'\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\"\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/papermc/paperweight/util/FileSystemReferenceImpl;", "Lio/papermc/paperweight/util/FileSystemReference;", "path", "Ljava/nio/file/Path;", "reference", "Ljava/nio/file/FileSystem;", "openers", "", "closed", "", "(Ljava/nio/file/Path;Ljava/nio/file/FileSystem;IZ)V", "getClosed", "()Z", "setClosed", "(Z)V", "getOpeners", "()I", "setOpeners", "(I)V", "close", "", "getPath", "", "getPathMatcher", "Ljava/nio/file/PathMatcher;", "matcher", "walkSequence", "Lkotlin/sequences/Sequence;", "options", "", "Lkotlin/io/path/PathWalkOption;", "([Lkotlin/io/path/PathWalkOption;)Lkotlin/sequences/Sequence;", "paperweight-lib"})
final class FileSystemReferenceImpl
implements FileSystemReference {
    @NotNull
    private final Path path;
    @NotNull
    private final FileSystem reference;
    private volatile int openers;
    private volatile boolean closed;

    public FileSystemReferenceImpl(@NotNull Path path, @NotNull FileSystem reference2, int openers, boolean closed) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        this.path = path;
        this.reference = reference2;
        this.openers = openers;
        this.closed = closed;
    }

    public /* synthetic */ FileSystemReferenceImpl(Path path, FileSystem fileSystem, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(path, fileSystem, n, bl);
    }

    public final int getOpeners() {
        return this.openers;
    }

    public final void setOpeners(int n) {
        this.openers = n;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @Override
    @NotNull
    public Path getPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = this.reference.getPath(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"reference.getPath(path)");
        return path2;
    }

    @Override
    @NotNull
    public Sequence<Path> walkSequence(PathWalkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return FileKt.walkSequence(this.reference, new PathWalkOption[0]);
    }

    @Override
    @NotNull
    public PathMatcher getPathMatcher(@NotNull String matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        PathMatcher pathMatcher = this.reference.getPathMatcher(matcher);
        Intrinsics.checkNotNullExpressionValue((Object)pathMatcher, (String)"reference.getPathMatcher(matcher)");
        return pathMatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        FileSystemReferenceImpl fileSystemReferenceImpl = this;
        synchronized (fileSystemReferenceImpl) {
            boolean bl = false;
            int n = this.openers;
            this.openers = n + -1;
            if (this.openers == 0) {
                try {
                    this.reference.close();
                }
                finally {
                    this.closed = true;
                    NioKt.access$getOpenJars$p().remove(this.path);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

