/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import java.security.MessageDigest;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR2\u0010\u000b\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\b0\b \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\b0\b\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lio/papermc/paperweight/util/HashingAlgorithm;", "", "algorithmName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getAlgorithmName", "()Ljava/lang/String;", "threadLocalDigest", "Ljava/security/MessageDigest;", "getThreadLocalDigest", "()Ljava/security/MessageDigest;", "threadLocalMessageDigest", "Ljava/lang/ThreadLocal;", "kotlin.jvm.PlatformType", "createDigest", "SHA256", "SHA1", "paperweight-lib"})
public final class HashingAlgorithm
extends Enum<HashingAlgorithm> {
    @NotNull
    private final String algorithmName;
    private final ThreadLocal<MessageDigest> threadLocalMessageDigest;
    public static final /* enum */ HashingAlgorithm SHA256 = new HashingAlgorithm("SHA-256");
    public static final /* enum */ HashingAlgorithm SHA1 = new HashingAlgorithm("SHA-1");
    private static final /* synthetic */ HashingAlgorithm[] $VALUES;

    private HashingAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
        this.threadLocalMessageDigest = ThreadLocal.withInitial(new Supplier(this){
            final /* synthetic */ HashingAlgorithm this$0;
            {
                this.this$0 = $receiver;
            }

            public final MessageDigest get() {
                return this.this$0.createDigest();
            }
        });
    }

    @NotNull
    public final String getAlgorithmName() {
        return this.algorithmName;
    }

    @NotNull
    public final MessageDigest createDigest() {
        MessageDigest messageDigest = MessageDigest.getInstance(this.algorithmName);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(algorithmName)");
        return messageDigest;
    }

    @NotNull
    public final MessageDigest getThreadLocalDigest() {
        MessageDigest messageDigest = this.threadLocalMessageDigest.get();
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"threadLocalMessageDigest.get()");
        return messageDigest;
    }

    public static HashingAlgorithm[] values() {
        return (HashingAlgorithm[])$VALUES.clone();
    }

    public static HashingAlgorithm valueOf(String value2) {
        return Enum.valueOf(HashingAlgorithm.class, value2);
    }

    static {
        $VALUES = hashingAlgorithmArray = new HashingAlgorithm[]{HashingAlgorithm.SHA256, HashingAlgorithm.SHA1};
    }
}

